/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactShortList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBasePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactDoublePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactFloatPaginatedList;
import java.io.IOException;
import java.nio.ShortBuffer;
import java.util.Objects;

public class OlapFactShortPaginatedList
extends OlapFactBasePaginatedList<short[], ShortBuffer>
implements IOlapFactShortList {
    private static long SHALLOW_SIZE_OF = -1L;
    private short[][] buffers = new short[1][];
    private int currentBuffer;
    private int currentBufferPos;
    private int size;

    public OlapFactShortPaginatedList(int bits) {
        super(bits);
        this.buffers[0] = new short[this.bufferItemCount];
        this.currentBuffer = 0;
        this.currentBufferPos = 0;
    }

    @Override
    protected int getBufferItemCountBits(int bits) {
        return bits - 1;
    }

    @Override
    public int getBufferCount() {
        return this.buffers.length;
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.buffers);
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            size += CdRamUsageEstimator.sizeOf((short[])this.buffers[ii]);
        }
        return size;
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public short getQuick(int offset) {
        return this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask];
    }

    @Override
    public void add(short val) {
        this.ensureCapacity();
        this.buffers[this.currentBuffer][this.currentBufferPos++] = val;
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Short)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactShortPaginatedList this$0;
            {
                OlapFactShortPaginatedList olapFactShortPaginatedList = this$0;
                Objects.requireNonNull(olapFactShortPaginatedList);
                this.this$0 = olapFactShortPaginatedList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Short[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Short.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    private void ensureCapacity() {
        short[] buffer = this.buffers[this.currentBuffer];
        if (this.currentBufferPos < buffer.length) {
            return;
        }
        if (buffer.length == this.bufferItemCount) {
            short[][] newBuffers = new short[this.buffers.length + 1][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = new short[this.bufferItemCount];
            this.buffers = newBuffers;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = 0;
            return;
        }
        short[] newBuffer = new short[this.bufferItemCount];
        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
        this.buffers[this.currentBuffer] = newBuffer;
    }

    @Override
    public void trimToSize() {
        if (this.currentBufferPos == 0) {
            if (this.currentBuffer == 0) {
                return;
            }
            short[][] newPages = new short[this.buffers.length - 1][];
            System.arraycopy(this.buffers, 0, newPages, 0, newPages.length);
            this.buffers = newPages;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = this.buffers[this.currentBuffer].length;
            return;
        }
        if (this.currentBufferPos < this.bufferItemCount) {
            short[] newPage = new short[this.currentBufferPos];
            System.arraycopy(this.buffers[this.currentBuffer], 0, newPage, 0, newPage.length);
            this.buffers[this.currentBuffer] = newPage;
            return;
        }
    }

    @Override
    public void setQuick(int offset, short val) {
        this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask] = val;
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        short value = this.getQuick(rowId);
        if (value != Short.MIN_VALUE) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        short[] values = this.buffers[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            short value = values[rowId & this.bufferItemCountMask];
            if (value == Short.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int pageNumber, int startOffset, int endOffset) {
        short[] page = this.buffers[pageNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            short value = page[offset];
            if (value == Short.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    public void copy(OlapFactDoublePaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            short[] buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.length; ++row, ++ii) {
                to.add(buffer[ii]);
            }
        }
    }

    public void copy(OlapFactFloatPaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            short[] buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.length; ++row, ++ii) {
                to.add(buffer[ii]);
            }
        }
    }

    @Override
    public int lookup(short lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startPageIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < this.buffers.length; ++idx) {
            short[] page = this.buffers[idx];
            for (int pageIdx = startPageIdx; rowId < this.size && pageIdx < page.length; ++rowId, ++pageIdx) {
                short value = page[pageIdx];
                if (lookupValue != value) continue;
                return rowId;
            }
            startPageIdx = 0;
        }
        return -1;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, short val) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.currentBuffer);
        out.writeInt(this.currentBufferPos);
        out.writeInt(this.size);
        out.writeInt(this.buffers == null ? -1 : this.buffers.length);
        if (this.buffers != null) {
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                short[] buffer = this.buffers[bb];
                out.writeInt(buffer == null ? -1 : buffer.length);
                if (buffer == null) continue;
                out.writeShorts(buffer);
            }
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.currentBuffer = in.readInt();
        this.currentBufferPos = in.readInt();
        this.size = in.readInt();
        int bufferCount = in.readInt();
        if (bufferCount > -1) {
            this.buffers = new short[bufferCount][];
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                int bufferLen = in.readInt();
                if (bufferLen <= -1) continue;
                this.buffers[bb] = new short[bufferLen];
                in.readShorts(this.buffers[bb]);
            }
        }
    }
}

