/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.common.utils.CdPackedBitList;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactPackedIntList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBasePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactDoublePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactFloatPaginatedList;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Objects;

public class OlapFactPackedPaginatedList
extends OlapFactBasePaginatedList<int[], IntBuffer>
implements IOlapFactPackedIntList {
    private static long SHALLOW_SIZE_OF = -1L;
    private final Object LOCK = new Object();
    private CdPackedBitList[] buffers;
    private int currentBuffer;
    private int currentBufferPos;
    private int size;

    public OlapFactPackedPaginatedList(int bits) {
        super(bits);
    }

    @Override
    protected int getBufferItemCountBits(int bits) {
        return bits;
    }

    @Override
    public int getBufferCount() {
        return this.buffers.length;
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.buffers);
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            size += this.buffers[ii].sizeOf();
        }
        return size;
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int getQuick(int offset) {
        return this.buffers[offset >> this.bufferItemCountBits].getInt(offset & this.bufferItemCountMask);
    }

    @Override
    public void add(int val) {
        this.ensureCapacity();
        this.buffers[this.currentBuffer].set(this.currentBufferPos++, val);
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Integer)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactPackedPaginatedList this$0;
            {
                OlapFactPackedPaginatedList olapFactPackedPaginatedList = this$0;
                Objects.requireNonNull(olapFactPackedPaginatedList);
                this.this$0 = olapFactPackedPaginatedList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Integer[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Integer.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    private void ensureCapacity() {
        CdPackedBitList buffer = this.buffers[this.currentBuffer];
        if (this.currentBufferPos < buffer.size()) {
            return;
        }
        if (buffer.size() == this.bufferItemCount) {
            CdPackedBitList[] newBuffers = new CdPackedBitList[this.buffers.length + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = this.buffers[0].newEmpty();
            this.buffers = newBuffers;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = 0;
            return;
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void trimToSize() {
        if (this.currentBufferPos == 0) {
            if (this.currentBuffer == 0) {
                return;
            }
            CdPackedBitList[] newPages = new CdPackedBitList[this.buffers.length - 1];
            System.arraycopy(this.buffers, 0, newPages, 0, newPages.length);
            this.buffers = newPages;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = this.buffers[this.currentBuffer].size();
            return;
        }
        if (this.currentBufferPos < this.bufferItemCount) {
            // empty if block
        }
    }

    @Override
    public void setQuick(int offset, int val) {
        this.buffers[offset >> this.bufferItemCountBits].set(offset & this.bufferItemCountMask, val);
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId, int nullMarker) {
        int value = this.getQuick(rowId);
        if (value != nullMarker) {
            aggregator.aggregate(value);
        }
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId, int nullMarker) {
        for (int i = startRowId; i < endRowId; ++i) {
            this.aggregatePoint(aggregator, i, nullMarker);
        }
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len, int nullMarker) {
        for (int rowId : rowIds) {
            this.aggregatePoint(aggregator, rowId, nullMarker);
        }
    }

    @Override
    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int pageNumber, int startOffset, int endOffset) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public void copy(OlapFactDoublePaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            CdPackedBitList buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.size(); ++row, ++ii) {
                to.add(buffer.getInt(ii));
            }
        }
    }

    public void copy(OlapFactFloatPaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            CdPackedBitList buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.size(); ++row, ++ii) {
                to.add(buffer.getInt(ii));
            }
        }
    }

    @Override
    public int lookup(int lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startPageIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < this.buffers.length; ++idx) {
            CdPackedBitList page = this.buffers[idx];
            for (int pageIdx = startPageIdx; rowId < this.size && pageIdx < page.size(); ++rowId, ++pageIdx) {
                int value = page.getInt(pageIdx);
                if (lookupValue != value) continue;
                return rowId;
            }
            startPageIdx = 0;
        }
        return -1;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int offset, int val) {
        int currentBuffer = offset >> this.bufferItemCountBits;
        int currentBufferPos = offset & this.bufferItemCountMask;
        this.ensureCapacityMT(currentBuffer).set(currentBufferPos, val);
    }

    private CdPackedBitList ensureCapacityMT(int currentBuffer) {
        CdPackedBitList buffer;
        if (currentBuffer >= this.buffers.length) {
            this.expandBuffersMT(currentBuffer);
        }
        if ((buffer = this.buffers[currentBuffer]).size() == this.bufferItemCount) {
            return buffer;
        }
        return this.expandBufferMT(currentBuffer);
    }

    private CdPackedBitList expandBufferMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            CdPackedBitList buffer = this.buffers[currentBuffer];
            if (buffer.size() == this.bufferItemCount) {
                return buffer;
            }
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CdPackedBitList expandBuffersMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (currentBuffer >= this.buffers.length) {
                CdPackedBitList[] newBuffers = new CdPackedBitList[currentBuffer + 1];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                for (int i = this.buffers.length; i < newBuffers.length; ++i) {
                    newBuffers[i] = this.buffers[0].newEmpty();
                }
                this.buffers = newBuffers;
            }
            return this.buffers[currentBuffer];
        }
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
    }
}

