/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactByteList;
import crazydev.iccube.olap.facts.column.list.IOlapFactIntList;
import crazydev.iccube.olap.facts.column.list.IOlapFactModifiedUtf8StringList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBytePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactIntPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.utf8.OlapFactModifiedUtf8StringPaginatedListHelper;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapFactModifiedUtf8StringPaginatedList
extends OlapFactPaginatedList
implements IOlapFactModifiedUtf8StringList {
    private static long SHALLOW_SIZE_OF = -1L;
    private final OlapFactModifiedUtf8StringPaginatedListHelper underlying;

    public OlapFactModifiedUtf8StringPaginatedList(final int bits) {
        this.underlying = new OlapFactModifiedUtf8StringPaginatedListHelper(new OlapFactModifiedUtf8StringPaginatedListHelper.Factory(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public IOlapFactIntList createInt() {
                return new OlapFactIntPaginatedList(bits);
            }

            @Override
            public IOlapFactByteList createBytes() {
                return new OlapFactBytePaginatedList(bits);
            }
        });
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.underlying.cleanupResources(cleaner);
    }

    @Override
    public int getBufferItemCount() {
        return 0;
    }

    @Override
    public int getBufferCount() {
        return this.underlying.getBufferCount();
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += this.underlying.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return this.underlying.sizeOfFiles();
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Nullable
    public String getQuick(int rowId) {
        return this.underlying.getValueAsObject(rowId);
    }

    @Override
    public void setQuick(int rowId, @Nullable String value) {
        this.underlying.setValueAsObject(rowId, value);
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, @Nullable String value) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void add(@Nullable String val) {
        this.underlying.addNewValue(val);
    }

    @Override
    public void trimToSize() {
        this.underlying.trimToSize();
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        this.underlying.aggregatePoints(aggregator, rowIds, len);
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        this.underlying.aggregatePoint(aggregator, rowId);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        this.underlying.aggregateRange(aggregator, startRowId, endRowId);
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        return this.underlying.lookup(lookupValue, start);
    }

    @Override
    public byte[] getModifiedUtf8(String value) {
        return this.underlying.getModifiedUtf8(value);
    }

    @Override
    public int compareToModifiedUtf8(String value, int rowId) {
        return this.underlying.compareToModifiedUtf8(value, rowId);
    }

    @Override
    public int hashCode(int rowId) {
        return this.underlying.hashCode(rowId);
    }

    @Override
    public byte[] getUnderlyingHackValue(int rowId) {
        return this.underlying.getUnderlyingHackValue(rowId);
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, String value, @Nullable IOlapFactExtraComparator extraComparator) {
        return this.underlying.binarySearch(sortList, value, extraComparator);
    }

    @Override
    public int binarySearchIgnoreCase(CdPaginatedIntList sortList, String value) {
        return this.underlying.binarySearchIgnoreCase(sortList, value);
    }

    @Override
    public boolean equalsIgnoreCase(int rowId, String name) {
        return this.underlying.equalsIgnoreCase(rowId, name);
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.underlying.save(context, out);
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.underlying.restore(context, in);
    }
}

