/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdArrays;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBasePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBytePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactDoublePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactIntPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactLongPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactShortPaginatedList;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Objects;

public class OlapFactFloatPaginatedList
extends OlapFactBasePaginatedList<float[], FloatBuffer>
implements IOlapFactFloatList {
    private static long SHALLOW_SIZE_OF = -1L;
    private final Object LOCK = new Object();
    private float[][] buffers = new float[1][];
    private int currentBuffer;
    private int currentBufferPos;
    private int size;

    public OlapFactFloatPaginatedList(int bits) {
        super(bits);
        this.buffers[0] = new float[this.bufferItemCount];
        this.currentBuffer = 0;
        this.currentBufferPos = 0;
    }

    public OlapFactFloatPaginatedList(OlapFactDoublePaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactFloatPaginatedList(OlapFactFloatPaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactFloatPaginatedList(OlapFactLongPaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactFloatPaginatedList(OlapFactIntPaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactFloatPaginatedList(OlapFactShortPaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactFloatPaginatedList(OlapFactBytePaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    @Override
    protected int getBufferItemCountBits(int bits) {
        return bits - 2;
    }

    @Override
    public int getBufferCount() {
        return this.buffers.length;
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.buffers);
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            size += CdRamUsageEstimator.sizeOf((float[])this.buffers[ii]);
        }
        return size;
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float getQuick(int rowId) {
        return this.buffers[rowId >> this.bufferItemCountBits][rowId & this.bufferItemCountMask];
    }

    @Override
    public void add(float val) {
        this.ensureCapacity();
        this.buffers[this.currentBuffer][this.currentBufferPos++] = val;
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add(((Float)values.get(ii)).floatValue());
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactFloatPaginatedList this$0;
            {
                OlapFactFloatPaginatedList olapFactFloatPaginatedList = this$0;
                Objects.requireNonNull(olapFactFloatPaginatedList);
                this.this$0 = olapFactFloatPaginatedList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Float[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Float.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    private void ensureCapacity() {
        float[] buffer = this.buffers[this.currentBuffer];
        if (this.currentBufferPos < buffer.length) {
            return;
        }
        if (buffer.length == this.bufferItemCount) {
            float[][] newBuffers = new float[this.buffers.length + 1][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = new float[this.bufferItemCount];
            this.buffers = newBuffers;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = 0;
            return;
        }
        float[] newBuffer = new float[this.bufferItemCount];
        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
        this.buffers[this.currentBuffer] = newBuffer;
    }

    @Override
    public void trimToSize() {
        if (this.currentBufferPos == 0) {
            if (this.currentBuffer == 0) {
                return;
            }
            float[][] newPages = new float[this.buffers.length - 1][];
            System.arraycopy(this.buffers, 0, newPages, 0, newPages.length);
            this.buffers = newPages;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = this.buffers[this.currentBuffer].length;
            return;
        }
        if (this.currentBufferPos < this.bufferItemCount) {
            float[] newPage = new float[this.currentBufferPos];
            System.arraycopy(this.buffers[this.currentBuffer], 0, newPage, 0, newPage.length);
            this.buffers[this.currentBuffer] = newPage;
            return;
        }
    }

    @Override
    public void setQuick(int offset, float val) {
        this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask] = val;
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        float[] values = this.buffers[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            float value = values[rowId & this.bufferItemCountMask];
            if (value == Float.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        float value = this.getQuick(rowId);
        if (value != Float.NEGATIVE_INFINITY) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int pageNumber, int startOffset, int endOffset) {
        float[] page = this.buffers[pageNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            float value = page[offset];
            if (value == Float.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    public void copy(OlapFactFloatPaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        to.buffers = CdArrays.copy((float[][])this.buffers);
        to.currentBufferPos = to.bufferItemCount;
        to.currentBuffer = to.buffers.length - 1;
        to.size = this.size;
    }

    @Override
    public int lookup(float lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startPageIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < this.buffers.length; ++idx) {
            float[] page = this.buffers[idx];
            for (int pageIdx = startPageIdx; rowId < this.size && pageIdx < page.length; ++rowId, ++pageIdx) {
                float value = page[pageIdx];
                if (lookupValue != value) continue;
                return rowId;
            }
            startPageIdx = 0;
        }
        return -1;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int offset, float val) {
        int currentBuffer = offset >> this.bufferItemCountBits;
        int currentBufferPos = offset & this.bufferItemCountMask;
        this.ensureCapacityMT((int)currentBuffer)[currentBufferPos] = val;
    }

    private float[] ensureCapacityMT(int currentBuffer) {
        float[] buffer;
        if (currentBuffer >= this.buffers.length) {
            this.expandBuffersMT(currentBuffer);
        }
        if ((buffer = this.buffers[currentBuffer]).length == this.bufferItemCount) {
            return buffer;
        }
        return this.expandBufferMT(currentBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float[] expandBufferMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            float[] buffer = this.buffers[currentBuffer];
            if (buffer.length == this.bufferItemCount) {
                return buffer;
            }
            float[] newBuffer = new float[this.bufferItemCount];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            this.buffers[currentBuffer] = newBuffer;
            return newBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float[] expandBuffersMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (currentBuffer >= this.buffers.length) {
                float[][] newBuffers = new float[currentBuffer + 1][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                for (int i = this.buffers.length; i < newBuffers.length; ++i) {
                    newBuffers[i] = new float[this.bufferItemCount];
                }
                this.buffers = newBuffers;
            }
            return this.buffers[currentBuffer];
        }
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.currentBuffer);
        out.writeInt(this.currentBufferPos);
        out.writeInt(this.size);
        out.writeInt(this.buffers == null ? -1 : this.buffers.length);
        if (this.buffers != null) {
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                float[] buffer = this.buffers[bb];
                out.writeInt(buffer == null ? -1 : buffer.length);
                if (buffer == null) continue;
                out.writeFloats(buffer);
            }
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.currentBuffer = in.readInt();
        this.currentBufferPos = in.readInt();
        this.size = in.readInt();
        int bufferCount = in.readInt();
        if (bufferCount > -1) {
            this.buffers = new float[bufferCount][];
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                int bufferLen = in.readInt();
                if (bufferLen <= -1) continue;
                this.buffers[bb] = new float[bufferLen];
                in.readFloats(this.buffers[bb]);
            }
        }
    }
}

