/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactComparableList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBasePaginatedList;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;

public class OlapFactComparablePaginatedList
extends OlapFactBasePaginatedList<Comparable[], ByteBuffer>
implements IOlapFactComparableList<Comparable> {
    private Comparable[][] buffers = new Comparable[1][];
    private int currentBuffer;
    private int currentBufferPos;
    private int size;

    public OlapFactComparablePaginatedList(int bits) {
        super(bits);
        this.buffers[0] = new Comparable[this.bufferItemCount];
        this.currentBuffer = 0;
        this.currentBufferPos = 0;
    }

    @Override
    protected int getBufferItemCountBits(int bits) {
        return bits;
    }

    @Override
    public int getBufferCount() {
        return -1;
    }

    @Override
    public long sizeOf() {
        return 0L;
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @Nullable
    public Comparable getQuick(int rowId) {
        return this.buffers[rowId >> this.bufferItemCountBits][rowId & this.bufferItemCountMask];
    }

    @Override
    public void setQuick(int rowId, @Nullable Comparable value) {
        this.buffers[rowId >> this.bufferItemCountBits][rowId & this.bufferItemCountMask] = value;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, @Nullable Comparable value) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void add(@Nullable Comparable val) {
        this.ensureCapacity();
        this.buffers[this.currentBuffer][this.currentBufferPos++] = val;
        ++this.size;
    }

    private void ensureCapacity() {
        Comparable[] buffer = this.buffers[this.currentBuffer];
        if (this.currentBufferPos < buffer.length) {
            return;
        }
        if (buffer.length == this.bufferItemCount) {
            Comparable[][] newBuffers = new Comparable[this.buffers.length + 1][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = new Comparable[this.bufferItemCount];
            this.buffers = newBuffers;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = 0;
            return;
        }
        Comparable[] newBuffer = new Comparable[this.bufferItemCount];
        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
        this.buffers[this.currentBuffer] = newBuffer;
    }

    @Override
    public void trimToSize() {
        if (this.currentBufferPos == 0) {
            if (this.currentBuffer == 0) {
                return;
            }
            Comparable[][] newPages = new Comparable[this.buffers.length - 1][];
            System.arraycopy(this.buffers, 0, newPages, 0, newPages.length);
            this.buffers = newPages;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = this.buffers[this.currentBuffer].length;
            return;
        }
        if (this.currentBufferPos < this.bufferItemCount) {
            Comparable[] newPage = new Comparable[this.currentBufferPos];
            System.arraycopy(this.buffers[this.currentBuffer], 0, newPage, 0, newPage.length);
            this.buffers[this.currentBuffer] = newPage;
            return;
        }
    }

    @Override
    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        Comparable value = this.getQuick(rowId);
        if (value != null) {
            aggregator.aggregate(value);
        }
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        throw new RuntimeException("internal error: inconsistent usage of comparable column");
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int pageNumber, int startOffset, int endOffset) {
        Comparable[] page = this.buffers[pageNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            Comparable value = page[offset];
            if (value == null) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startPageIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < this.buffers.length; ++idx) {
            Comparable[] page = this.buffers[idx];
            for (int pageIdx = startPageIdx; rowId < this.size && pageIdx < page.length; ++rowId, ++pageIdx) {
                Comparable value = page[pageIdx];
                if (!lookupValue.equals(value)) continue;
                return rowId;
            }
            startPageIdx = 0;
        }
        return -1;
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.currentBuffer);
        out.writeInt(this.currentBufferPos);
        out.writeInt(this.size);
        out.writeInt(this.buffers == null ? -1 : this.buffers.length);
        if (this.buffers != null) {
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                Comparable[] buffer = this.buffers[bb];
                out.writeInt(buffer == null ? -1 : buffer.length);
                if (buffer == null) continue;
                out.writeComparables(buffer);
            }
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.currentBuffer = in.readInt();
        this.currentBufferPos = in.readInt();
        this.size = in.readInt();
        int bufferCount = in.readInt();
        if (bufferCount > -1) {
            this.buffers = new Comparable[bufferCount][];
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                int bufferLen = in.readInt();
                if (bufferLen <= -1) continue;
                this.buffers[bb] = new Comparable[bufferLen];
                in.readComparables(this.buffers[bb]);
            }
        }
    }
}

