/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactByteList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBasePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactDoublePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactFloatPaginatedList;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OlapFactBytePaginatedList
extends OlapFactBasePaginatedList<byte[], ByteBuffer>
implements IOlapFactByteList {
    private static long SHALLOW_SIZE_OF = -1L;
    private byte[][] buffers = new byte[1][];
    private int currentBuffer;
    private int currentBufferPos;
    private int size;

    public OlapFactBytePaginatedList(int bits) {
        super(bits);
        this.buffers[0] = new byte[this.bufferItemCount];
        this.currentBuffer = 0;
        this.currentBufferPos = 0;
    }

    @Override
    protected int getBufferItemCountBits(int bits) {
        return bits;
    }

    @Override
    public int getBufferCount() {
        return this.buffers.length;
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.buffers);
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            size += CdRamUsageEstimator.sizeOf((byte[])this.buffers[ii]);
        }
        return size;
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public byte getQuick(int offset) {
        return this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask];
    }

    @Override
    public byte[] getQuick(int startRowId, byte eos) {
        int endRowId = this.lookup(eos, startRowId);
        if (endRowId < startRowId) {
            throw new CdProgrammingException("internal error: missing EOS marker [" + endRowId + "][" + startRowId + "] [" + this.getClass().getSimpleName() + "][" + this.bits + "][" + this.bufferItemCountBits + "]");
        }
        byte[] bytes = new byte[endRowId - startRowId];
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        int bytesOffset = this.doGetQuick(bytes, 0, startPageNb, startPageOffset, startPageNb == endPageNb ? endPageOffset : this.bufferItemCount);
        for (int pageNb = startPageNb + 1; pageNb < endPageNb; ++pageNb) {
            bytesOffset += this.doGetQuick(bytes, bytesOffset, pageNb, 0, this.bufferItemCount);
        }
        if (endPageNb > startPageNb && endPageOffset != 0) {
            this.doGetQuick(bytes, bytesOffset, endPageNb, 0, endPageOffset);
        }
        return bytes;
    }

    private int doGetQuick(byte[] bytes, int bytesOffset, int pageNb, int from, int to) {
        int len = to - from;
        System.arraycopy(this.buffers[pageNb], from, bytes, bytesOffset, len);
        return len;
    }

    @Override
    public void add(byte val) {
        this.ensureCapacity();
        this.buffers[this.currentBuffer][this.currentBufferPos++] = val;
        ++this.size;
    }

    @Override
    public void add(byte[] values) {
        int written;
        if (values.length == 0) {
            return;
        }
        for (int offset = 0; offset < values.length; offset += written) {
            this.ensureCapacity();
            written = this.write(values, offset);
            if (written > 0) continue;
            throw new RuntimeException("internal error: byte-list inconsistent processing");
        }
        this.size += values.length;
    }

    private int write(byte[] values, int offset) {
        if (offset >= values.length) {
            return 0;
        }
        int availableWriteLen = this.bufferItemCount - this.currentBufferPos;
        if (availableWriteLen <= 0) {
            return 0;
        }
        int toWriteLen = values.length - offset;
        int canWriteLen = toWriteLen >= availableWriteLen ? availableWriteLen : toWriteLen;
        System.arraycopy(values, offset, this.buffers[this.currentBuffer], this.currentBufferPos, canWriteLen);
        this.currentBufferPos += canWriteLen;
        return canWriteLen;
    }

    private void ensureCapacity() {
        byte[] buffer = this.buffers[this.currentBuffer];
        if (this.currentBufferPos < buffer.length) {
            return;
        }
        if (buffer.length == this.bufferItemCount) {
            byte[][] newBuffers = new byte[this.buffers.length + 1][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = new byte[this.bufferItemCount];
            this.buffers = newBuffers;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = 0;
            return;
        }
        byte[] newBuffer = new byte[this.bufferItemCount];
        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
        this.buffers[this.currentBuffer] = newBuffer;
    }

    @Override
    public void trimToSize() {
        if (this.currentBufferPos == 0) {
            if (this.currentBuffer == 0) {
                return;
            }
            byte[][] newPages = new byte[this.buffers.length - 1][];
            System.arraycopy(this.buffers, 0, newPages, 0, newPages.length);
            this.buffers = newPages;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = this.buffers[this.currentBuffer].length;
            return;
        }
        if (this.currentBufferPos < this.bufferItemCount) {
            byte[] newPage = new byte[this.currentBufferPos];
            System.arraycopy(this.buffers[this.currentBuffer], 0, newPage, 0, newPage.length);
            this.buffers[this.currentBuffer] = newPage;
            return;
        }
    }

    @Override
    public void setQuick(int offset, byte val) {
        this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask] = val;
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        byte value = this.getQuick(rowId);
        aggregator.aggregate(value);
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        byte[] values = this.buffers[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            byte value = values[rowId & this.bufferItemCountMask];
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int pageNumber, int startOffset, int endOffset) {
        byte[] page = this.buffers[pageNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            byte value = page[offset];
            aggregator.aggregate(value);
        }
    }

    public void copy(OlapFactDoublePaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            byte[] buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.length; ++row, ++ii) {
                to.add(buffer[ii]);
            }
        }
    }

    public void copy(OlapFactFloatPaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            byte[] buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.length; ++row, ++ii) {
                to.add(buffer[ii]);
            }
        }
    }

    @Override
    public int lookup(byte lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int bufferStart = start >> this.bufferItemCountBits;
        int bufferStartOffset = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = bufferStart; idx < this.buffers.length; ++idx) {
            byte[] buffer = this.buffers[idx];
            for (int pageIdx = bufferStartOffset; rowId < this.size && pageIdx < buffer.length; ++rowId, ++pageIdx) {
                byte value = buffer[pageIdx];
                if (lookupValue != value) continue;
                return rowId;
            }
            bufferStartOffset = 0;
        }
        return -1;
    }

    @Override
    public void createZeroBuffers(int bufferCount) {
        byte[] values = new byte[this.bufferItemCount];
        for (int ii = 0; ii < bufferCount; ++ii) {
            this.add(values);
        }
        this.trimToSize();
    }

    @Override
    public void getQuick(byte[] dest, int destPos, int startRowId, int len) {
        int endRowId = startRowId + len;
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        if (startPageNb != endPageNb && (endPageNb - startPageNb != 1 || endPageOffset != 0)) {
            throw new CdProgrammingException("internal error: unexpected len (crossing buffer boundary)");
        }
        System.arraycopy(this.buffers[startPageNb], startPageOffset, dest, destPos, len);
    }

    @Override
    public void setQuick(int startRowId, byte[] values, int valuesPos, int valuesLen) {
        int endRowId = startRowId + valuesLen;
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        if (startPageNb != endPageNb && (endPageNb - startPageNb != 1 || endPageOffset != 0)) {
            throw new CdProgrammingException("internal error: unexpected len (crossing buffer boundary)");
        }
        System.arraycopy(values, valuesPos, this.buffers[startPageNb], startPageOffset, valuesLen);
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.currentBuffer);
        out.writeInt(this.currentBufferPos);
        out.writeInt(this.size);
        out.writeInt(this.buffers == null ? -1 : this.buffers.length);
        if (this.buffers != null) {
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                byte[] buffer = this.buffers[bb];
                out.writeInt(buffer == null ? -1 : buffer.length);
                if (buffer == null) continue;
                out.writeBytes(buffer);
            }
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.currentBuffer = in.readInt();
        this.currentBufferPos = in.readInt();
        this.size = in.readInt();
        int bufferCount = in.readInt();
        if (bufferCount > -1) {
            this.buffers = new byte[bufferCount][];
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                int bufferLen = in.readInt();
                if (bufferLen <= -1) continue;
                this.buffers[bb] = new byte[bufferLen];
                in.readBytes(this.buffers[bb]);
            }
        }
    }
}

