/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactBoolList;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactLongPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.bool.OlapFactBooleanPaginatedListHelper;
import java.io.IOException;

public class OlapFactBoolPaginatedList
extends OlapFactPaginatedList
implements IOlapFactBoolList {
    private static long SHALLOW_SIZE_OF = -1L;
    private final OlapFactLongPaginatedList underlying;
    private int size;

    public OlapFactBoolPaginatedList(int bits) {
        this.underlying = new OlapFactLongPaginatedList(bits);
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.underlying.cleanupResources(cleaner);
    }

    @Override
    public int getBufferItemCount() {
        return 0;
    }

    @Override
    public int getBufferCount() {
        return this.underlying.getBufferCount();
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += this.underlying.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean getQuick(int rowId) {
        return OlapFactBooleanPaginatedListHelper.get(this.underlying, rowId);
    }

    public void setNew(int rowId, Boolean val) {
        this.size = Math.max(rowId + 1, this.size);
        this.ensureCapacity(rowId);
        OlapFactBooleanPaginatedListHelper.set(this.underlying, rowId, val);
    }

    @Override
    public void add(boolean val) {
        OlapFactBooleanPaginatedListHelper.add(this.underlying, val, this.size);
        ++this.size;
    }

    @Override
    public void setQuick(int rowId, boolean val) {
        this.set(rowId, val);
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, boolean fact) {
        this.ensureCapacity(rowId);
        this.set(rowId, fact);
    }

    private void ensureCapacity(int rowId) {
        this.underlying.ensureCapacity(OlapFactBooleanPaginatedListHelper.sizeForLong(rowId));
    }

    private void set(int rowId, boolean val) {
        OlapFactBooleanPaginatedListHelper.set(this.underlying, rowId, val);
    }

    @Override
    public void trimToSize() {
        this.underlying.trimToSize();
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        aggregator.aggregate(OlapBooleanEntity.value(this.getQuick(rowId)));
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        for (int ii = startRowId; ii < endRowId; ++ii) {
            this.aggregatePoint(aggregator, ii);
        }
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.size);
        this.underlying.save(context, out);
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.size = in.readInt();
        if (context.isVersion0()) {
            OlapFactLongPaginatedList nullValues = new OlapFactLongPaginatedList(this.underlying.bits);
            OlapFactBoolPaginatedList.restoreForVersion0(context, in, nullValues, this.underlying);
            return;
        }
        this.underlying.restore(context, in);
    }

    public static void restoreForVersion0(N_RestoreContext context, S_BackupInputStream in, IOlapFactLongList nullValues, IOlapFactLongList values) throws IOException {
        nullValues.restore(context, in);
        values.restore(context, in);
        int nullValuesS = nullValues.size();
        int valuesS = values.size();
        if (nullValuesS != valuesS) {
            throw new RuntimeException("internal error: inconsistent backup [" + String.valueOf(nullValues) + "][" + valuesS + "]");
        }
        OlapFactBoolPaginatedList.applyNulls(values, nullValues);
    }

    public static void applyNulls(IOlapFactLongList values, IOlapFactLongList nullValues) {
        int size = nullValues.size();
        for (int ii = 0; ii < size; ++ii) {
            long nullValue = nullValues.getQuick(ii);
            if (nullValue == 0L) continue;
            long value = values.getQuick(ii);
            values.setQuick(ii, value &= nullValue ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

