/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedList;
import java.nio.Buffer;

public abstract class OlapFactBasePaginatedList<ARRAY, BUFFER extends Buffer>
extends OlapFactPaginatedList {
    protected final int bits;
    protected final int bufferItemCount;
    protected final int bufferItemCountBits;
    protected final int bufferItemCountMask;

    public OlapFactBasePaginatedList(int bits) {
        int _bufferItemCountBits = this.getBufferItemCountBits(bits);
        if (_bufferItemCountBits <= 0) {
            bits = 15;
        }
        this.bits = bits;
        this.bufferItemCountBits = this.getBufferItemCountBits(bits);
        if (this.bufferItemCountBits <= 0) {
            throw new CdRuntimeException("internal error: buffer size error [" + this.getClass().getSimpleName() + "][" + bits + "][" + this.bufferItemCountBits + "]");
        }
        this.bufferItemCountMask = (1 << this.bufferItemCountBits) - 1;
        this.bufferItemCount = 1 << this.bufferItemCountBits;
    }

    protected abstract int getBufferItemCountBits(int var1);

    public int getBufferItemCount() {
        return this.bufferItemCount;
    }

    public abstract int getBufferCount();

    public void cleanupResources(OlapFileCleaner cleaner) {
    }

    public abstract int size();

    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        this.doAggregateRange(aggregator, startPageNb, startPageOffset, startPageNb == endPageNb ? endPageOffset : this.bufferItemCount);
        for (int pageNb = startPageNb + 1; pageNb < endPageNb; ++pageNb) {
            this.doAggregateRange(aggregator, pageNb, 0, this.bufferItemCount);
        }
        if (endPageNb > startPageNb && endPageOffset != 0) {
            this.doAggregateRange(aggregator, endPageNb, 0, endPageOffset);
        }
    }

    protected abstract void doAggregateRange(OlapScalarEntityFactColumn.Aggregator var1, int var2, int var3, int var4);

    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        int b1 = rowIds[0] >> this.bufferItemCountBits;
        int b2 = rowIds[len - 1] >> this.bufferItemCountBits;
        if (b1 == b2) {
            this.aggregateSingleBufferPoints(aggregator, b1, rowIds, len);
        } else {
            this.aggregateMultiBufferPoints(aggregator, rowIds, len);
        }
    }

    protected abstract void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator var1, int var2, int[] var3, int var4);

    protected void aggregateMultiBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    protected abstract void aggregatePoint(OlapScalarEntityFactColumn.Aggregator var1, int var2);
}

