/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleVectorAggregator;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.facts.column.list.IOlapFactVectorList;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapVectorScalarEntityFactColumn<FACTS extends IOlapFactVectorList, T>
extends OlapScalarEntityFactColumn<T> {
    private final FACTS facts;

    protected OlapVectorScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType factDataType) {
        super(listFactory, id, factDataType);
        this.facts = this.createFacts(listFactory);
    }

    protected abstract FACTS createFacts(IOlapFactListFactory var1);

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.facts.cleanupResources(cleaner);
    }

    @Override
    public void trimToSize() {
        this.facts.trimToSize();
    }

    @Override
    public int size() {
        return this.facts.size();
    }

    @Override
    public long sizeOf() {
        return this.facts.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return this.facts.sizeOfFiles();
    }

    @Override
    public int getSortOrder() {
        return 0;
    }

    @Override
    public boolean shouldTransformToDistinctCount(DistinctCountOptimType distinctCountOptim) {
        return false;
    }

    @Override
    public final void setValueAt(int rowId, Object value, OlapFactRowAggregationType factRowAggregationType) {
        throw new CdRuntimeException(null, new OlapError(OlapErrorCode.NO_AGGREGATION_FOR_COLUMN_TYPE, new Serializable[]{this.getFriendlyTypeName(), this.id.toStringForError()}));
    }

    @Override
    @Nullable
    public Comparable getValueAsObject(int rowId) {
        return this.facts.getComparable(rowId);
    }

    @Override
    public boolean isNullFact(int rowId) {
        return this.facts.isNull(rowId);
    }

    @Override
    protected void addNewNullFact() {
        this.facts.add(null);
    }

    @Override
    protected void addNewNonNullFact(Object value) {
        CdComparableArray values = (CdComparableArray)value;
        this.facts.add(values);
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        throw new RuntimeException("internal error: inconsistent lookup method usage");
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, Comparable compKey, @Nullable IOlapFactExtraComparator extraComparator) {
        throw new RuntimeException("internal error: inconsistent search method usage");
    }

    @Override
    public OlapScalarEntity getValuedForDrillthrough(int rowId) {
        OlapScalarEntityFactColumn.Aggregator aggregator = this.createAggregator(OlapAggregationType.SUM);
        this.aggregatePoint(aggregator, rowId);
        OlapScalarEntity value = aggregator.asScalarEntity();
        return value;
    }

    @Override
    public OlapScalarEntityFactColumn.Aggregator createAggregator(OlapAggregationType aggregationType) {
        switch (aggregationType) {
            case SUM: 
            case SUM_HIGH_PRECISION: {
                return new OlapFactColumnSumDoubleVectorAggregator(false);
            }
            case AVG_LEAVES: {
                return new OlapFactColumnSumDoubleVectorAggregator(true);
            }
        }
        return this.onAggregationTypeNotSupported(aggregationType);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        this.facts.aggregateRange(aggregator, startRowId, endRowId);
    }

    @Override
    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        this.facts.aggregatePoint(aggregator, rowId);
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        this.facts.aggregatePoints(aggregator, rowIds, len);
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.facts.save(context, out);
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.facts.restore(context, in);
    }
}

