/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdIComparableList;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapComparableEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.IOException;
import java.util.ArrayList;

public class OlapMany2ManyScalarEntityFactColumn
extends OlapComparableEntityFactColumn {
    public OlapMany2ManyScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
    }

    @Override
    public String getFriendlyTypeName() {
        return "m-2-m";
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        CdIComparableList array;
        Object value;
        int ii;
        int itemsCount = this.size();
        int intCount = 0;
        for (ii = 0; ii < itemsCount; ++ii) {
            if (ii % 4096 == 0 && context.isCancelling()) {
                return;
            }
            value = this.facts.getQuick(ii);
            if (value != null) {
                if (value instanceof Integer) {
                    ++intCount;
                } else if (value instanceof CdIComparableList) {
                    array = (CdIComparableList)value;
                    intCount += array.size();
                }
            }
            ++intCount;
        }
        out.writeInt(intCount);
        for (ii = 0; ii < itemsCount; ++ii) {
            if (ii % 4096 == 0 && context.isCancelling()) {
                return;
            }
            value = this.facts.getQuick(ii);
            if (value != null) {
                if (value instanceof Integer) {
                    out.writeInt((Integer)value);
                } else if (value instanceof CdIComparableList) {
                    array = (CdIComparableList)value;
                    for (int cc = 0; cc < array.size(); ++cc) {
                        out.writeInt((Integer)array.get(cc));
                    }
                }
            }
            out.writeInt(Integer.MIN_VALUE);
        }
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int intCount = in.readInt();
        ArrayList<Integer> values = null;
        for (int ii = 0; ii < intCount; ++ii) {
            if (ii % 4096 == 0 && context.isCancelling()) {
                return;
            }
            int value = in.readInt();
            if (value != Integer.MIN_VALUE) {
                if (values == null) {
                    values = new ArrayList<Integer>();
                }
                values.add(value);
                continue;
            }
            if (values == null) {
                this.addNewValue(null);
                continue;
            }
            if (values.size() == 1) {
                this.addNewValue(values.get(0));
                values = null;
                continue;
            }
            this.addNewValue(new CdComparableArray(values));
            values = null;
        }
        if (values != null) {
            throw new RuntimeException("internal error: unexpected m-2-m content");
        }
    }
}

