/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapBaseDateScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactComparableList;
import crazydev.iccube.olap.facts.column.list.IOlapFactDateList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapDateScalarEntityFactColumn
extends OlapBaseDateScalarEntityFactColumn<LocalDate> {
    private final IOlapFactDateList myFacts;

    public OlapDateScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
        this.myFacts = (IOlapFactDateList)this.facts;
    }

    @Override
    public String getFriendlyTypeName() {
        return "date";
    }

    @Override
    protected IOlapFactComparableList createFactPaginatedList(IOlapFactListFactory listFactory) {
        return listFactory.createDateList(this);
    }

    @Override
    protected Class<LocalDate> getColumnType() {
        return LocalDate.class;
    }

    @Override
    public OlapScalarEntity getValuedForDrillthrough(int rowId) {
        Comparable rawValue = this.getRawFact(rowId);
        if (rawValue == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        return new OlapDateEntity((LocalDate)rawValue);
    }

    @Override
    public int getQuickDateMillis(int rowId) {
        return this.myFacts.getQuickDateMillis(rowId);
    }

    @Override
    public int getSortOrder() {
        return 1;
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.myFacts.save(context, out);
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.myFacts.restore(context, in);
    }

    @Override
    public Object transformValueForCompare(Comparable value) {
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        return value;
    }
}

