/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnGenericAggregator;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapRawTypeScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactBooleanList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class OlapBooleanScalarEntityFactColumn
extends OlapRawTypeScalarEntityFactColumn {
    private final IOlapFactBooleanList facts;

    public OlapBooleanScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
        this.facts = listFactory.createBooleanList(this);
    }

    @Override
    public OlapScalarEntityTidyType getTidyEntityType() {
        return OlapScalarEntityTidyType.LOGICAL;
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.facts.cleanupResources(cleaner);
    }

    @Override
    public String getFriendlyTypeName() {
        return "boolean";
    }

    @Override
    public int size() {
        return this.facts.size();
    }

    @Override
    @Nullable
    public Comparable getValueAsObject(int rowId) {
        if (this.hasNulls() && this.isNullFact(rowId)) {
            return null;
        }
        return Boolean.valueOf(this.getRawFact(rowId));
    }

    @Override
    public final boolean isNullFact(int rowId) {
        return this.facts.isNull(rowId);
    }

    public boolean getRawFact(int rowId) {
        return this.facts.getQuick(rowId);
    }

    @Override
    protected void addNewNullFact() {
        this.facts.addNull();
    }

    @Override
    protected void addNewNonNullFact(Object value) {
        Boolean fact = (Boolean)value;
        this.facts.add(fact);
    }

    @Override
    protected void setRawFact(int rowId, @Nullable Object value) {
        if (value != null) {
            Boolean fact = (Boolean)value;
            this.facts.setQuick(rowId, fact);
        } else {
            this.setHasNulls();
            this.facts.setQuickNull(rowId);
        }
    }

    @Override
    protected void doAggregateFact(int rowId, Object value) {
        Boolean fact = (Boolean)value;
        this.facts.setQuick(rowId, fact & this.facts.getQuick(rowId));
    }

    @Override
    public OlapScalarEntityFactColumn.Aggregator createAggregator(OlapAggregationType aggregationType) {
        return new OlapFactColumnGenericAggregator(null, aggregationType);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        this.facts.aggregateRange(aggregator, startRowId, endRowId);
    }

    @Override
    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        this.facts.aggregatePoint(aggregator, rowId);
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        this.facts.aggregatePoints(aggregator, rowIds, len);
    }

    @Override
    public OlapScalarEntity getValuedForDrillthrough(int rowId) {
        if (this.isNullFact(rowId)) {
            return OlapEmptyEntity.INSTANCE;
        }
        boolean rawValue = this.getRawFact(rowId);
        return OlapBooleanEntity.value(rawValue);
    }

    @Override
    public void trimToSize() {
        this.facts.trimToSize();
    }

    @Override
    public long sizeOf() {
        return this.facts.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return this.facts.sizeOfFiles();
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        if (lookupValue instanceof Boolean) {
            return this.facts.lookup((Boolean)lookupValue, start);
        }
        return -1;
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, Comparable compKey, @Nullable IOlapFactExtraComparator extraComparator) {
        if (compKey instanceof Boolean) {
            boolean value = (Boolean)compKey;
            int low = 0;
            int high = sortList.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int misKeySortedIdx = sortList.getInt(mid);
                boolean midVal = this.getRawFact(misKeySortedIdx);
                long comp = value == midVal ? 0 : (value ? 1 : -1);
                if (comp == 0L && extraComparator != null) {
                    comp = extraComparator.compareOtherColumns(misKeySortedIdx);
                }
                if (comp > 0L) {
                    low = mid + 1;
                    continue;
                }
                if (comp < 0L) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low - 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int compareToValueForCompare(Object value, int rowId) {
        Comparable valueAsObject = this.getValueAsObject(rowId);
        if (value == null) {
            return valueAsObject == null ? 0 : -1;
        }
        return valueAsObject == null ? 1 : -valueAsObject.compareTo(value);
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.facts.save(context, out);
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.facts.restore(context, in);
    }
}

