/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.aggregator;

import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import org.jetbrains.annotations.Nullable;

public final class OlapFactColumnSumDoubleVectorAggregator
extends OlapScalarEntityFactColumn.Aggregator {
    private final boolean avg;
    private int count = 0;
    private double[] vector;

    public OlapFactColumnSumDoubleVectorAggregator(boolean avg) {
        this.avg = avg;
    }

    @Nullable
    public double[] getVector() {
        return this.vector;
    }

    @Override
    public void aggregate(IOlapDoubleValueIterable values) {
        int size = values.size();
        if (this.vector == null || size > this.vector.length) {
            this.ensureCapacity(values.size());
        }
        ++this.count;
        for (int i = 0; i < size; ++i) {
            int n = i;
            this.vector[n] = this.vector[n] + values.value(i);
        }
    }

    private void ensureCapacity(int size) {
        if (size == 0) {
            return;
        }
        if (this.vector == null) {
            this.vector = new double[size];
        } else {
            double[] nVector = new double[size];
            System.arraycopy(this.vector, 0, nVector, 0, this.vector.length);
            this.vector = nVector;
        }
    }

    @Override
    public OlapScalarEntity asScalarEntity() {
        if (this.vector != null) {
            if (this.avg) {
                this.divideByCount();
            }
            return new OlapDoubleVectorEntity(this.vector);
        }
        return OlapEmptyEntity.INSTANCE;
    }

    private void divideByCount() {
        int i = 0;
        while (i < this.vector.length) {
            int n = i++;
            this.vector[n] = this.vector[n] / (double)this.count;
        }
    }
}

