/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts;

import crazydev.common.collection.CdAction;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.olap.entity.member.OlapMember;

public abstract class OlapFactMemberLineHelper {
    private OlapFactMemberLineHelper() {
    }

    public static void resolveMembersWithAction(OlapBuilderContext context, OlapMember[] members, CdAction<OlapMember> action) {
        for (int ii = 0; ii < members.length; ++ii) {
            OlapMember member = members[ii];
            boolean aggregateOnAncestors = member.aggrFactsOnAncestors();
            OlapFactMemberLineHelper.resolveMembersWithAction(context, aggregateOnAncestors, member, action);
        }
    }

    private static void resolveMembersWithAction(OlapBuilderContext context, boolean aggregateOnAncestors, OlapMember member, CdAction<OlapMember> action) {
        OlapFactMemberLineHelper.resolveMemberAndAncestorsWithAction(aggregateOnAncestors, member, action);
        OlapFactMemberLineHelper.resolveDerivedHierarchiesWithAction(context, member, action);
    }

    private static void resolveMemberAndAncestorsWithAction(boolean aggregateOnAncestors, OlapMember member, CdAction<OlapMember> action) {
        if (!member.isLeaf()) {
            member.getHierarchy().setNotStandardRollupBroken();
        }
        do {
            if (member.isFactHollow() || member.isAll()) continue;
            action.apply((Object)member);
        } while ((member = aggregateOnAncestors ? member.getParent() : null) != null);
    }

    private static void resolveDerivedHierarchiesWithAction(OlapBuilderContext context, OlapMember baseMember, CdAction<OlapMember> action) {
        context.forEachNoBaseMembers(baseMember, (CdAction<OlapMember>)((CdAction)member -> OlapFactMemberLineHelper.resolveMemberAndAncestorsWithAction(member.aggrFactsOnAncestors(), member, action)));
    }
}

