/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.facts.IOlapCubeFactsForEval;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapFactCubeManager
implements IOlapCubeFactsForEval {
    private final OlapRegularCube cube;
    private final Map<String, OlapFactMeasureGroupBaseManager> factManagersPerMeasureGroupName = new CdCaseInsensitiveHashMap();
    private final Map<IOlapBuilderBaseFactsDef, OlapFactMeasureGroupBaseManager> factManagersPerMeasureGroup = new IdentityHashMap<IOlapBuilderBaseFactsDef, OlapFactMeasureGroupBaseManager>();

    public OlapFactCubeManager(OlapBuilderContext context, IOlapFactListFactory factColumnListFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory, OlapRegularCube cube) {
        this.cube = cube;
        for (IOlapBuilderBaseFactsDef factsDef : cube.getCubeFacts()) {
            OlapSchema schema = cube.getSchema();
            if (schema.useFactsPartitioning() && !context.isFactsPartitioningLicensed()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_PARTITION_NOT_LICENSED, new Serializable[0]);
            }
            OlapPartitioningType partitionType = schema.useFactsPartitioning() ? factsDef.getPartitioningType() : OlapPartitioningType.NONE;
            M_FactsLocalMeasureGroupManager factBaseManager = new M_FactsLocalMeasureGroupManager(context, factColumnListFactory, factsBitmapContainerFactory, cube, factsDef, partitionType);
            this.factManagersPerMeasureGroupName.put(factsDef.getMeasureGroupName(), factBaseManager);
            this.factManagersPerMeasureGroup.put(factsDef, factBaseManager);
        }
    }

    public List<String> getMeasureGroupNames(IOlapCubePermission cPerms, OlapDimension dimension) {
        ArrayList<String> measureGroups = new ArrayList<String>();
        for (OlapFactMeasureGroupBaseManager measureGroup : this.factManagersPerMeasureGroup.values()) {
            String measureGroupName = measureGroup.getMeasureGroupName();
            if (!cPerms.isMeasureGroupAuthorized(measureGroupName) || !measureGroup.containsDimension(dimension)) continue;
            measureGroups.add(measureGroupName);
        }
        return measureGroups;
    }

    public List<String> getMeasureGroupCaptions(Locale locale, IOlapCubePermission cPerms, OlapDimension dimension) {
        ArrayList<String> measureGroups = new ArrayList<String>();
        for (OlapFactMeasureGroupBaseManager measureGroup : this.factManagersPerMeasureGroup.values()) {
            String measureGroupName = measureGroup.getMeasureGroupName();
            if (!cPerms.isMeasureGroupAuthorized(measureGroupName) || !measureGroup.containsDimension(dimension)) continue;
            OlapSchemaLocalization localization = this.cube.getSchema().getLocalization();
            String caption = localization.getMeasureGroupCaption(locale, this.cube, measureGroupName);
            measureGroups.add(CdStringUtils.isNotNullAndNotBlank((String)caption) ? caption : measureGroupName);
        }
        return measureGroups;
    }

    public List<OlapFactMeasureGroupBaseManager> getMeasureGroups(Set<IOlapBuilderBaseFactsDef> factsDefs) {
        ArrayList<OlapFactMeasureGroupBaseManager> measureGroups = new ArrayList<OlapFactMeasureGroupBaseManager>();
        for (OlapFactMeasureGroupBaseManager measureGroup : this.factManagersPerMeasureGroup.values()) {
            if (!factsDefs.contains(measureGroup.getFactsDefinition())) continue;
            measureGroups.add(measureGroup);
        }
        return measureGroups;
    }

    public void setupClusterInformation() {
        for (OlapFactMeasureGroupBaseManager manager : this.factManagersPerMeasureGroupName.values()) {
            manager.setupClusterInformation();
        }
    }

    public void resetForSchema(OlapSchema schema, int nextDimensionIndexOffset, int nextHierarchyIndexOffset, int nextPartitionIndexOffset) {
        for (OlapFactMeasureGroupBaseManager factManager : this.factManagersPerMeasureGroupName.values()) {
            factManager.resetForSchema(schema, nextDimensionIndexOffset, nextHierarchyIndexOffset, nextPartitionIndexOffset);
        }
    }

    public OlapFactMeasureGroupBaseManager getFactManager(String measureGroupName) {
        return this.factManagersPerMeasureGroupName.get(measureGroupName);
    }

    @Override
    @Nullable
    public OlapFactMeasureGroupBaseManager getFactManager(OlapMeasureMember measure) {
        return this.factManagersPerMeasureGroup.get(measure.getMeasureGroup());
    }

    @Override
    public List<String> getLinkingMeasureGroups(OlapDimension dimension) {
        ArrayList<String> names = new ArrayList<String>();
        this.factManagersPerMeasureGroupName.forEach((measGroupName, mea) -> {
            if (mea.getIndexingDimensions().contains(dimension)) {
                names.add((String)measGroupName);
            }
        });
        return names;
    }

    public Collection<OlapFactMeasureGroupBaseManager> getFactManagers() {
        return this.factManagersPerMeasureGroup.values();
    }

    public OlapRegularCube getCube() {
        return this.cube;
    }

    public int getFactsCount() {
        return this.factManagersPerMeasureGroupName.size();
    }

    public boolean containsDimension(OlapDimension dimension) {
        for (OlapFactMeasureGroupBaseManager factBaseManager : this.factManagersPerMeasureGroup.values()) {
            if (!factBaseManager.containsDimension(dimension)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDimension(OlapDimension dimension, String measureGroupName) {
        OlapFactMeasureGroupBaseManager facts = this.factManagersPerMeasureGroupName.get(measureGroupName);
        return facts != null && facts.containsDimension(dimension);
    }

    public List<OlapDimension> getIndexingDimensions() {
        List<OlapDimension> dimensions = null;
        if (this.factManagersPerMeasureGroup.size() == 1) {
            for (OlapFactMeasureGroupBaseManager measureGroup : this.factManagersPerMeasureGroupName.values()) {
                dimensions = measureGroup.getIndexingDimensions();
            }
        } else {
            dimensions = new ArrayList<OlapDimension>();
            BitSet indices = new BitSet();
            for (OlapFactMeasureGroupBaseManager measureGroup : this.factManagersPerMeasureGroupName.values()) {
                List<OlapDimension> mgDimensions = measureGroup.getIndexingDimensions();
                int size = mgDimensions.size();
                for (int dd = 0; dd < size; ++dd) {
                    OlapDimension mgDimension = mgDimensions.get(dd);
                    if (indices.get(mgDimension.getDimensionalityIndex())) continue;
                    indices.set(mgDimension.getDimensionalityIndex());
                    dimensions.add(mgDimension);
                }
            }
        }
        if (dimensions == null) {
            throw new RuntimeException("internal error: inconsistent indexing dimensions for cube [" + this.cube.getNameX() + "]");
        }
        return dimensions;
    }

    @Nullable
    public Collection<OlapDimension> getIndexingDimensions(String measureName) {
        for (OlapFactMeasureGroupBaseManager factBaseManager : this.factManagersPerMeasureGroup.values()) {
            if (!factBaseManager.containsMeasure(measureName)) continue;
            return factBaseManager.getIndexingDimensions();
        }
        return null;
    }

    public void deleteCategoryHierarchyBitmaps(OlapHierarchy hierarchy) {
        for (OlapFactMeasureGroupBaseManager manager : this.factManagersPerMeasureGroupName.values()) {
            manager.deleteCategoryHierarchyBitmaps(hierarchy);
        }
    }

    public List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> partitions, String cube) {
        for (OlapFactMeasureGroupBaseManager manager : this.factManagersPerMeasureGroup.values()) {
            manager.listPartitions(partitions, cube, manager.getMeasureGroupName());
        }
        return partitions;
    }

    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info) {
        for (OlapFactMeasureGroupBaseManager manager : this.factManagersPerMeasureGroup.values()) {
            OlapLoggers.GENERAL.warn((Object)("[###] facts : " + manager.getMeasureGroupName()));
            manager.getInformationForPerformanceTests(info);
        }
    }

    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies) throws IOException {
        for (OlapFactMeasureGroupBaseManager manager : this.factManagersPerMeasureGroup.values()) {
            OlapLoggers.GENERAL.info((Object)("[DumpSchemaIndex] facts : " + manager.getMeasureGroupName()));
            manager.dumpIndex(out, hierarchies);
        }
    }

    public List<OlapFactsStats> createStats(OlapStatsContext context, Map<String, OlapDimensionStats> dimensions) {
        ArrayList<OlapFactsStats> facts = new ArrayList<OlapFactsStats>();
        for (OlapFactMeasureGroupBaseManager manager : this.factManagersPerMeasureGroup.values()) {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[stats] facts : " + manager.getMeasureGroupName()));
            }
            facts.add(manager.createStats(context, dimensions));
        }
        return facts;
    }

    public List<OlapFactsStats> createIncrLoadStats(OlapStatsContext context) {
        ArrayList<OlapFactsStats> facts = new ArrayList<OlapFactsStats>();
        for (OlapFactMeasureGroupBaseManager manager : this.factManagersPerMeasureGroup.values()) {
            facts.add(manager.createIncrLoadStats(context));
        }
        return facts;
    }

    public boolean adoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, OlapFactCubeManager loadedCubeFactManager, Set<IOlapBuilderBaseFactsDef> loadedFactsDefs) {
        boolean adopted = false;
        Logger schemaLogger = context.getSchemaLogger();
        for (IOlapBuilderBaseFactsDef loadedFactsDef : loadedFactsDefs) {
            OlapFactMeasureGroupBaseManager loadedMeasureGroupManager = loadedCubeFactManager.factManagersPerMeasureGroup.get(loadedFactsDef);
            if (loadedMeasureGroupManager == null) {
                if (!schemaLogger.isInfoEnabled()) continue;
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " cube [" + this.cube.getNameX() + "] missing loaded facts [" + loadedFactsDef.getName() + "]"));
                continue;
            }
            OlapFactMeasureGroupBaseManager existingMeasureGroupManager = this.factManagersPerMeasureGroup.get(loadedFactsDef);
            if (existingMeasureGroupManager == null) {
                if (!schemaLogger.isInfoEnabled()) continue;
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " cube [" + this.cube.getNameX() + "] missing existings facts [" + loadedFactsDef.getName() + "]"));
                continue;
            }
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " cube [" + this.cube.getNameX() + "] updating facts [" + loadedFactsDef.getName() + "]"));
            }
            if (!existingMeasureGroupManager.adoptPartitions(context, bContext, loadedMeasureGroupManager)) continue;
            adopted = true;
        }
        return adopted;
    }

    public boolean unloadPartitions(OlapBuilderUnloadPartitionsContext context, OlapFactMeasureGroupBaseManager measureGroup, List<String> partitionKeys) {
        if (!this.factManagersPerMeasureGroup.containsValue(measureGroup)) {
            throw new RuntimeException("internal error: cube [" + this.getCube().getNameX() + "] missing measure group [" + measureGroup.getMeasureGroupName() + "]");
        }
        boolean unloaded = false;
        Logger schemaLogger = context.getSchemaLogger();
        if (schemaLogger.isInfoEnabled()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " schema [" + this.cube.getSchema().getName() + "] cube [" + this.cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading facts"));
        }
        if (measureGroup.unloadPartitions(context, partitionKeys)) {
            unloaded = true;
        }
        return unloaded;
    }

    @Nullable
    public OlapFactMeasureGroupBaseManager lookupMeasureGroup(S_MeasureGroupRef measureGroupRef) {
        for (OlapFactMeasureGroupBaseManager measureGroup : this.factManagersPerMeasureGroup.values()) {
            if (!measureGroup.getClusterRef().equals(measureGroupRef)) continue;
            return measureGroup;
        }
        return null;
    }
}

