/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.executor;

import crazydev.iccube.olap.executor.OlapScheduledTimeGenerator;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class OlapScheduledThreadPoolExecutorService
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = System.nanoTime();
    private final String logName;

    public OlapScheduledThreadPoolExecutorService(String logName, int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), threadFactory);
        this.logName = logName;
    }

    final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    protected void onTaskDone(ScheduledFuture<?> task) {
    }

    private void delayedExecute(RunnableScheduledFuture command) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException();
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        long delayMS = command.getDelay(TimeUnit.MILLISECONDS);
        long nextScheduleAt = System.currentTimeMillis() + delayMS;
        if (delayMS < 0L && command instanceof ScheduledFutureTaskX) {
            ScheduledFutureTaskX task = (ScheduledFutureTaskX)command;
            if (task.timeGenerator.isTerminated()) {
                OlapLoggers.SCHEDULER.info((Object)(this.logName + " next (init)schedule at [terminated] [" + String.valueOf(command) + "]"));
                command.cancel(true);
                return;
            }
        }
        OlapLoggers.SCHEDULER.info((Object)(this.logName + " next (init)schedule at [" + String.valueOf(new Date(nextScheduleAt)) + "] [" + String.valueOf(command) + "]"));
        super.getQueue().add(command);
    }

    @Override
    public boolean remove(Runnable task) {
        if (!(task instanceof RunnableScheduledFuture)) {
            return false;
        }
        return this.getQueue().remove(task);
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return task;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return task;
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long _triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay));
    }

    long triggerTime(long delay) {
        return this.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)super.getQueue().peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(this, command, null, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<V> t = this.decorateTask(callable, new ScheduledFutureTask<V>(this, callable, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(this, command, null, this.triggerTime(initialDelay, unit), unit.toNanos(period)));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture<?> _scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(this, command, null, this._triggerTime(initialDelay, unit), unit.toNanos(period)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(this, command, null, this.triggerTime(initialDelay, unit), unit.toNanos(-delay)));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture<?> scheduleWithTimeGenerator(Runnable command, OlapScheduledTimeGenerator generator) {
        if (command == null || generator == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTaskX<Object>(this, command, null, generator));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return false;
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return false;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
    }

    @Override
    public void shutdown() {
        super.shutdownNow();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    private static class DelayedWorkQueue
    extends AbstractCollection<Runnable>
    implements BlockingQueue<Runnable> {
        private final DelayQueue<RunnableScheduledFuture> dq = new DelayQueue();

        private DelayedWorkQueue() {
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.dq.poll();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.dq.peek();
        }

        @Override
        public Runnable take() throws InterruptedException {
            return (Runnable)this.dq.take();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            return (Runnable)this.dq.poll(timeout, unit);
        }

        @Override
        public boolean add(Runnable x) {
            return this.dq.add((RunnableScheduledFuture)x);
        }

        @Override
        public boolean offer(Runnable x) {
            return this.dq.offer((RunnableScheduledFuture)x);
        }

        @Override
        public void put(Runnable x) {
            this.dq.put((RunnableScheduledFuture)x);
        }

        @Override
        public boolean offer(Runnable x, long timeout, TimeUnit unit) {
            return this.dq.offer((RunnableScheduledFuture)x, timeout, unit);
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.dq.remove();
        }

        @Override
        public Runnable element() {
            return (Runnable)this.dq.element();
        }

        @Override
        public void clear() {
            this.dq.clear();
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.dq.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.dq.drainTo(c, maxElements);
        }

        @Override
        public int remainingCapacity() {
            return this.dq.remainingCapacity();
        }

        @Override
        public boolean remove(Object x) {
            return this.dq.remove(x);
        }

        @Override
        public boolean contains(Object x) {
            return this.dq.contains(x);
        }

        @Override
        public int size() {
            return this.dq.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dq.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.dq.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.dq.toArray(array);
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Iterator<Runnable>(this){
                private Iterator<RunnableScheduledFuture> it;
                final /* synthetic */ DelayedWorkQueue this$0;
                {
                    DelayedWorkQueue delayedWorkQueue = this$0;
                    Objects.requireNonNull(delayedWorkQueue);
                    this.this$0 = delayedWorkQueue;
                    this.it = this.this$0.dq.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Runnable next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    private class ScheduledFutureTaskX<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private final OlapScheduledTimeGenerator timeGenerator;
        private final String toStringInfo;
        private int runCount;
        private long timeMS;
        final /* synthetic */ OlapScheduledThreadPoolExecutorService this$0;

        ScheduledFutureTaskX(OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService, Runnable r, V result, OlapScheduledTimeGenerator timeGenerator) {
            OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService2 = olapScheduledThreadPoolExecutorService;
            Objects.requireNonNull(olapScheduledThreadPoolExecutorService2);
            this.this$0 = olapScheduledThreadPoolExecutorService2;
            super(r, result);
            this.timeGenerator = timeGenerator;
            this.runCount = 0;
            this.timeMS = timeGenerator.generateNextTimeMS(this.runCount++, true, System.currentTimeMillis());
            this.sequenceNumber = sequencer.getAndIncrement();
            this.toStringInfo = r.toString();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long nowMS = System.currentTimeMillis();
            long delayMS = this.timeMS - nowMS;
            long delay = unit.convert(delayMS, TimeUnit.MILLISECONDS);
            return delay;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTaskX) {
                ScheduledFutureTaskX x = (ScheduledFutureTaskX)other;
                long diff = this.timeMS - x.timeMS;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        @Override
        public boolean isPeriodic() {
            return true;
        }

        private void runPeriodic() {
            boolean ok = ScheduledFutureTaskX.super.runAndReset();
            boolean down = this.this$0.isShutdown();
            if (ok && !down) {
                this.timeMS = this.timeGenerator.generateNextTimeMS(this.runCount++, false, System.currentTimeMillis());
                if (this.timeMS < 0L && this.timeGenerator.isTerminated()) {
                    OlapLoggers.SCHEDULER.info((Object)(this.this$0.logName + " next (re)schedule at [terminated] [" + String.valueOf(this) + "]"));
                    this.cancel(true);
                } else {
                    long delayMS = this.getDelay(TimeUnit.MILLISECONDS);
                    long nextScheduleAt = System.currentTimeMillis() + delayMS;
                    OlapLoggers.SCHEDULER.info((Object)(this.this$0.logName + " next (re)schedule at [" + String.valueOf(new Date(nextScheduleAt)) + "] [" + String.valueOf(this) + "]"));
                    OlapScheduledThreadPoolExecutorService.super.getQueue().add(this);
                }
            }
        }

        @Override
        public void run() {
            this.runPeriodic();
        }

        @Override
        protected void done() {
            super.done();
            this.this$0.onTaskDone(this);
        }

        @Override
        public String toString() {
            return this.toStringInfo;
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private final long period;
        private final String toStringInfo;
        private long time;
        final /* synthetic */ OlapScheduledThreadPoolExecutorService this$0;

        ScheduledFutureTask(OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService, Runnable r, V result, long ns) {
            OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService2 = olapScheduledThreadPoolExecutorService;
            Objects.requireNonNull(olapScheduledThreadPoolExecutorService2);
            this.this$0 = olapScheduledThreadPoolExecutorService2;
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
            this.toStringInfo = r.toString();
        }

        ScheduledFutureTask(OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService, Runnable r, V result, long ns, long period) {
            OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService2 = olapScheduledThreadPoolExecutorService;
            Objects.requireNonNull(olapScheduledThreadPoolExecutorService2);
            this.this$0 = olapScheduledThreadPoolExecutorService2;
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
            this.toStringInfo = r.toString();
        }

        ScheduledFutureTask(OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService, Callable<V> callable, long ns) {
            OlapScheduledThreadPoolExecutorService olapScheduledThreadPoolExecutorService2 = olapScheduledThreadPoolExecutorService;
            Objects.requireNonNull(olapScheduledThreadPoolExecutorService2);
            this.this$0 = olapScheduledThreadPoolExecutorService2;
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
            this.toStringInfo = callable.toString();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - this.this$0.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void runPeriodic() {
            boolean ok = ScheduledFutureTask.super.runAndReset();
            boolean down = this.this$0.isShutdown();
            if (ok && !down) {
                long p = this.period;
                if (p > 0L) {
                    this.time += p;
                    long _now = this.this$0.now();
                    if (this.time - _now < 0L) {
                        while (this.time < _now) {
                            this.time += p;
                        }
                        this.time -= p;
                    }
                } else {
                    this.time = this.this$0.triggerTime(-p);
                }
                long delayMS = this.getDelay(TimeUnit.MILLISECONDS);
                long nextScheduleAt = System.currentTimeMillis() + delayMS;
                OlapLoggers.SCHEDULER.info((Object)(this.this$0.logName + " next (re)schedule at [" + String.valueOf(new Date(nextScheduleAt)) + "] [" + String.valueOf(this) + "]"));
                OlapScheduledThreadPoolExecutorService.super.getQueue().add(this);
            }
        }

        @Override
        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                ScheduledFutureTask.super.run();
            }
        }

        @Override
        protected void done() {
            super.done();
            this.this$0.onTaskDone(this);
        }

        @Override
        public String toString() {
            return this.toStringInfo;
        }
    }
}

