/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.executor;

import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorService;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.select.context.IOlapExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;

public abstract class OlapMdxThreadPoolExecutorService
extends OlapThreadPoolExecutorService<IOlapExecutionContext> {
    public OlapMdxThreadPoolExecutorService(String type, int threadCount) {
        super(type, threadCount);
    }

    @Override
    public boolean isMdx() {
        return true;
    }

    @Override
    protected OlapThreadPoolExecutorService.ExecutingContext doCreateExecutingContext(String type, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, IOlapExecutionContext context, int queueSize) {
        return new ExecutingContext(type, schedulingPolicy, context, queueSize);
    }

    public static class ExecutingContext
    extends OlapThreadPoolExecutorService.ExecutingContext<IOlapExecutionContext> {
        public ExecutingContext(String type, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, IOlapExecutionContext executionContext, int queueSize) {
            super(type, schedulingPolicy, executionContext, queueSize);
        }

        @Override
        protected void reportResolvedException(IOlapExecutionContext executionContext, Throwable error) {
            CdRuntimeException unexpected = this.createUnexpectedException(executionContext, error);
            if (this.reportException(unexpected)) {
                OlapLoggers.MDX_EVALUATION.error((Object)"MDX evaluation unexpected exception", (Throwable)unexpected);
            }
        }

        @Override
        protected void reportResolvedRuntimeException(IOlapExecutionContext executionContext, RuntimeException error) {
            CdRuntimeException unexpected = this.createUnexpectedException(executionContext, error);
            if (this.reportException(unexpected)) {
                OlapLoggers.MDX_EVALUATION.error((Object)"MDX evaluation unexpected (runtime) exception", (Throwable)unexpected);
            }
        }

        @Override
        protected void reportResolvedCdRuntimeException(IOlapExecutionContext executionContext, CdRuntimeException error) {
            CdRuntimeException unexpected = this.createUnexpectedException(executionContext, error);
            if (this.reportException(unexpected)) {
                OlapLoggers.MDX_EVALUATION.error((Object)"MDX evaluation unexpected (runtime-x) exception", (Throwable)unexpected);
            }
        }

        private CdRuntimeException createUnexpectedException(IOlapExecutionContext executionContext, Throwable error) {
            if (error instanceof OlapEvaluationException) {
                OlapEvaluationException evalError = (OlapEvaluationException)((Object)error);
                if (evalError.isCausedBy(OlapErrorCode.SELECT_MAX_CELL_COUNT)) {
                    return evalError;
                }
                return evalError;
            }
            if (error instanceof StackOverflowError) {
                return new OlapEvaluationException(error, executionContext.asExceptionContext(), OlapErrorCode.CALC_MEMBER_STACK_OVERFLOW, new Serializable[]{error.getMessage()});
            }
            return new OlapEvaluationException(error, executionContext.asExceptionContext(), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{error.getMessage()});
        }
    }
}

