/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.tableaggregator;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.result.OlapResCreateSetBlankStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.OlapTableAggregatorRepository;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapSetTableAggregatorEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSetTableAggregatorStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapSetTableAggregatorStatementInstr
extends OlapCreateStatementInstr<OlapSetTableAggregatorStatementExecutionContext> {
    private final String aggrName;
    private final OlapEntityIdentifier measureId;

    public OlapSetTableAggregatorStatementInstr(OlapInstrLocationRange range, String aggrName, OlapEntityIdentifier measureId) {
        super(range);
        this.aggrName = aggrName;
        this.measureId = measureId;
    }

    @Override
    public String typeForError() {
        return "CREATE SET_TABLE_AGGREGATOR";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            // empty if block
        }
    }

    @Override
    protected OlapSetTableAggregatorStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapSetTableAggregatorStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapSetTableAggregatorStatementExecutionContext context) {
        OlapSchema schema = context.getSchema();
        OlapRegularCube cube = schema.getFirstCube();
        OlapMeasureMember measure = this.lookupMeasure(context, cube);
        OlapEngineComponent engine = context.getRequestContext().getOlapEngineComponent();
        OlapTableAggregatorRepository repository = engine.getTableAggregationRepository();
        IOlapFactTableAggregatorFactory tableAggregator = repository.lookupAggregator(this.aggrName);
        if (tableAggregator == null) {
            return (OlapEntity)OlapSetTableAggregatorStatementInstr.onInstrExecutionError(context, OlapErrorCode.TABLE_AGGR_MISSING, new Serializable[]{this.aggrName});
        }
        measure.setTableAggregator(tableAggregator);
        return new OlapResCreateSetBlankStatementDataSet(schema.getName(), "?", this.aggrName);
    }

    @Override
    public String toStringForDebugger() {
        return "CREATE TABLE_AGGREGATOR : " + this.aggrName;
    }

    private OlapMeasureMember lookupMeasure(OlapSetTableAggregatorStatementExecutionContext context, OlapRegularCube cube) {
        OlapSetTableAggregatorEvaluationContext eContext = new OlapSetTableAggregatorEvaluationContext(context, cube);
        OlapNonScalarEntity entity = eContext.lookupEntityByMdxIdentifier(eContext.getNameContext(), OlapMdxEntityLookupKinds.CUBE_ENTITY, this.measureId);
        if (entity instanceof OlapMeasureMember) {
            OlapMeasureMember measure = (OlapMeasureMember)entity;
            return measure;
        }
        if (entity.isMdxNull()) {
            return (OlapMeasureMember)OlapSetTableAggregatorStatementInstr.onInstrExecutionError(context, OlapErrorCode.TABLE_AGGR_MEASURE_UNKNOWN, new Serializable[]{this.aggrName, this.measureId.asMdxString()});
        }
        return (OlapMeasureMember)OlapSetTableAggregatorStatementInstr.onInstrExecutionError(context, OlapErrorCode.TABLE_AGGR_MEASURE_TYPE_MISMATCH, new Serializable[]{this.aggrName, this.measureId.asMdxString(), entity.getFriendlyTypeName()});
    }
}

