/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.set;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluation;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.eval.set.OlapSetInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSetManager {
    private final OlapSchema schema;
    private final Map<IOlapSchemaPermission, Map<String, OlapSetEvaluation>> staticSets = new ConcurrentHashMap<IOlapSchemaPermission, Map<String, OlapSetEvaluation>>();

    public OlapSetManager(OlapSchema schema) {
        this.schema = schema;
    }

    protected abstract String kind();

    protected void info(Logger builder, String info) {
        builder.info((Object)("[set-" + this.kind() + "] [schema : " + this.schema.getName() + "] " + info));
    }

    protected void info(String info) {
        this.info(OlapLoggers.BUILDER, info);
    }

    public void onSchemaPartitionsUnloaded(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        this.info("onSchemaPartitionsUnloaded()");
        this.staticSets.clear();
    }

    public void onSchemaPartitionsLoaded(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        this.info("onSchemaPartitionsLoaded()");
        this.staticSets.clear();
    }

    public void onSchemaPartitionsLoadError() {
        this.info("onSchemaPartitionsLoadError()");
        this.staticSets.clear();
    }

    public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.info(context.getLoggers().builder(), "onSchemaIncrLoaded()");
        this.staticSets.clear();
    }

    public void onSchemaIncrLoadedOnError() {
        this.info("onSchemaIncrLoadedOnError()");
        this.staticSets.clear();
    }

    public void onScriptStatementApplied(OlapScriptInformation information) {
        this.info("onScriptStatementApplied()");
        this.staticSets.clear();
    }

    protected void deleteSetDeclaration(OlapSetDeclaration setDeclaration) {
        this.info("deleteSetDeclaration( " + setDeclaration.getSetName() + " )");
        for (Map<String, OlapSetEvaluation> sets : this.staticSets.values()) {
            sets.remove(setDeclaration.getSetName());
        }
    }

    public void onSecurityAllPermissionsRemoved() {
        this.info("onSecurityAllPermissionsRemoved()");
        this.staticSets.clear();
    }

    public void onSecurityPermissionsSwitched(OlapEngineRequestContext context, @Nullable IOlapSchemaPermission prevPerms) {
        this.info(context.getLoggers().builder(), "onSecurityPermissionsSwitched(" + (prevPerms != null ? "<...>" : "<null>") + ")");
        if (prevPerms == null) {
            return;
        }
        this.staticSets.remove(prevPerms);
    }

    @Nullable
    public OlapSetEvaluation getEvaluatedStaticSetDeclaration(OlapEvaluationContext context, OlapSetDeclaration setDeclaration) {
        if (this.schema != context.getSchema()) {
            throw new CdProgrammingException("internal error: schema mismatch!");
        }
        Map<String, OlapSetEvaluation> lazySets = this.staticSets.get(context.getSchemaPermissions());
        if (lazySets != null) {
            String setNameLC = setDeclaration.getSetName().toLowerCase();
            OlapSetEvaluation lazySet = lazySets.get(setNameLC);
            return lazySet;
        }
        return null;
    }

    public OlapSetEvaluation evaluateStaticSetDeclaration(OlapEvaluationContext context, OlapSetDeclaration setDeclaration) {
        if (this.schema != context.getSchema()) {
            throw new CdProgrammingException("internal error: schema mismatch!");
        }
        Map lazySets = this.staticSets.computeIfAbsent(context.getSchemaPermissions(), perms -> new ConcurrentHashMap());
        String setNameLC = setDeclaration.getSetName().toLowerCase();
        try {
            OlapTupleSet set = setDeclaration.evaluate(context);
            OlapSetEvaluation eval = new OlapSetEvaluation(setDeclaration, set, null);
            lazySets.put(setNameLC, eval);
            return eval;
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)("set [" + setDeclaration.getQualifiedSetName() + "] evaluation error"), (Throwable)ex);
            OlapSetEvaluation eval = new OlapSetEvaluation(setDeclaration, null, ex);
            return eval;
        }
    }

    @Nullable
    public OlapSetInfo getSetInfo(IOlapSchemaPermission perms, OlapSetDeclaration set) {
        Map<String, OlapSetEvaluation> sets = this.staticSets.get(perms);
        if (sets == null) {
            return null;
        }
        String setName = set.getSetName();
        OlapSetEvaluation lazy = sets.get(setName);
        if (lazy == null) {
            return null;
        }
        return lazy.getInfo();
    }
}

