/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.OlapDynamicSetPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapListTupleSetPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapTupleSetPreparedInstr;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class OlapSetInstr
extends OlapExecutedWithPreparedInstr<OlapEvaluationContext> {
    private final OlapInstr[] items;

    public OlapSetInstr(OlapInstrLocationRange range, OlapInstr[] items) {
        super(range);
        this.items = items;
        for (OlapInstr item : items) {
            item.setParent(this);
        }
    }

    @Override
    public String typeForError() {
        return "SET";
    }

    public OlapInstr[] getItems() {
        return this.items;
    }

    @Override
    public boolean isConstrainedEnabled() {
        return false;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            for (OlapInstr item : this.items) {
                item.accept(v);
            }
        }
    }

    @Override
    public OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        if (this.items.length == 0) {
            return new OlapListTupleSetPreparedInstr(this, OlapSetFactory.empty());
        }
        boolean quickActive = true;
        int quickMemberCount = 0;
        int quickTupleCount = 0;
        OlapPreparedInstr[] pItems = new OlapPreparedInstr[this.items.length];
        for (int ii = 0; ii < this.items.length; ++ii) {
            OlapInstr item = this.items[ii];
            OlapPreparedInstr pItem = item.prepare(context);
            if (quickActive) {
                if (pItem.isQuickToMemberApplicable(context)) {
                    ++quickMemberCount;
                } else if (pItem.isQuickToTupleApplicable(context)) {
                    ++quickTupleCount;
                } else {
                    quickActive = pItem.isQuickToListSetApplicable(context);
                }
            }
            pItems[ii] = pItem;
        }
        OlapPreparedInstr instr = quickActive ? this.doPrepareAsQuickSet(context, pItems, quickMemberCount, quickTupleCount) : this.doPrepareAsDynamicSet(context, pItems);
        return instr;
    }

    private OlapPreparedInstr doPrepareAsDynamicSet(IOlapPrepareContext context, OlapPreparedInstr[] items) {
        return new OlapDynamicSetPreparedInstr(this, items);
    }

    private OlapPreparedInstr doPrepareAsQuickSet(IOlapPrepareContext context, OlapPreparedInstr[] items, int quickMemberCount, int quickTupleCount) {
        if (quickMemberCount == items.length) {
            return this.doPrepareAsQuickMemberSet(context, items);
        }
        if (quickTupleCount == items.length) {
            return this.doPrepareAsQuickTupleSet(context, items);
        }
        return this.doPrepareAsQuickSet(context, items);
    }

    private OlapPreparedInstr doPrepareAsQuickMemberSet(IOlapPrepareContext context, OlapPreparedInstr[] items) {
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        OlapMember prevMember = null;
        for (int ii = 0; ii < items.length; ++ii) {
            OlapPreparedInstr item = items[ii];
            OlapMember member = item.toQuickNullableMember(context);
            if (member == null || member.isMdxNull()) continue;
            if (prevMember != null) {
                OlapTupleDimensionalityHelper.assertDimensionality((IOlapEvaluationExceptionContext)context, prevMember, member);
            }
            members.add(member);
            prevMember = member;
        }
        OlapListTupleSet asSet = OlapSetFactory.instance(members);
        return new OlapListTupleSetPreparedInstr(this, asSet);
    }

    private OlapPreparedInstr doPrepareAsQuickTupleSet(IOlapPrepareContext context, OlapPreparedInstr[] items) {
        ArrayList<OlapTuple> tuples = new ArrayList<OlapTuple>();
        for (int ii = 0; ii < items.length; ++ii) {
            OlapPreparedInstr item = items[ii];
            OlapTuple tuple = item.toQuickTuple(context);
            if (!OlapSetInstr.isTupleValidForSet(context.getMemberTupleFilter(), tuple)) continue;
            tuples.add(tuple);
        }
        OlapTupleDimensionalityHelper.assertDimensionality(context, tuples);
        OlapListTupleSet<OlapTuple> asSet = OlapSetFactory.instance(tuples);
        return new OlapListTupleSetPreparedInstr(this, asSet);
    }

    private OlapPreparedInstr doPrepareAsQuickSet(IOlapPrepareContext context, OlapPreparedInstr[] items) {
        ArrayList<OlapTupleSet<? extends OlapTuple>> sets = new ArrayList<OlapTupleSet<? extends OlapTuple>>();
        for (int ii = 0; ii < items.length; ++ii) {
            OlapPreparedInstr item = items[ii];
            if (item.isQuickToTupleApplicable(context)) {
                OlapTuple tuple = item.toQuickTuple(context);
                if (!OlapSetInstr.isTupleValidForSet(context.getMemberTupleFilter(), tuple)) continue;
                sets.add(OlapSetFactory.singleton(tuple));
                continue;
            }
            if (item.isQuickToListSetApplicable(context)) {
                OlapListTupleSet set = item.toQuickListSet(context);
                sets.add(set);
                continue;
            }
            throw new RuntimeException("internal error: inconsistent quick-set setup [" + item.getClass().getSimpleName() + "]");
        }
        OlapIterator<? extends OlapTuple> union = OlapIteratorFactory.union(context, sets, true);
        OlapTupleSet<? extends OlapTuple> asSet = OlapSetFactory.instance(union);
        return new OlapTupleSetPreparedInstr(this, asSet);
    }

    public static boolean isTupleValidForSet(@Nullable OlapTupleFilter filter, OlapTuple tuple) {
        return tuple.isOK() && tuple.exists(filter);
    }

    @Override
    public String toStringForDebugger() {
        return "Set";
    }
}

