/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.set;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapSetDeclarationManager {
    private final Map<String, OlapSetDeclaration> setDeclarations = new CdCaseInsensitiveHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSetDeclaration get(String name) {
        Map<String, OlapSetDeclaration> map = this.setDeclarations;
        synchronized (map) {
            return this.setDeclarations.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNames() {
        Map<String, OlapSetDeclaration> map = this.setDeclarations;
        synchronized (map) {
            ArrayList<String> names = new ArrayList<String>(this.setDeclarations.keySet());
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSetDeclaration> getDeclarations(@Nullable IOlapSchemaPermission perms) {
        Map<String, OlapSetDeclaration> map = this.setDeclarations;
        synchronized (map) {
            ArrayList<OlapSetDeclaration> declarations = new ArrayList<OlapSetDeclaration>();
            for (OlapSetDeclaration declaration : this.setDeclarations.values()) {
                if (perms != null && !perms.isSetAuthorized(declaration.getSetName())) continue;
                declarations.add(new OlapSetDeclaration(declaration.isForSelect(), declaration.getCubeName(), declaration.getSetName(), declaration.isSessionScoped(), declaration.isDynamicEvaluation(), declaration.getMdx(), declaration.getFormula(), declaration.getDisplayFolder(), declaration.getDescription()));
            }
            return declarations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        Map<String, OlapSetDeclaration> map = this.setDeclarations;
        synchronized (map) {
            return this.setDeclarations.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIfNotContained(OlapInstrLocationRange definitionRange, IOlapSchemaPermission schemaPermissions, @Nullable String cube, String name, boolean sessionScoped, boolean dynamicEvaluation, String mdx, OlapInstr formula, @Nullable String displayFolder, @Nullable String description) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(definitionRange, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        Map<String, OlapSetDeclaration> map = this.setDeclarations;
        synchronized (map) {
            if (this.contains(name)) {
                throw new OlapEvaluationException(definitionRange, OlapErrorCode.DUPLICATED_NAMED_SET, new Serializable[]{name});
            }
            this.setDeclarations.put(name, new OlapSetDeclaration(false, cube, name, sessionScoped, dynamicEvaluation, mdx, formula, displayFolder, description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSetDeclaration remove(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, String name) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        Map<String, OlapSetDeclaration> map = this.setDeclarations;
        synchronized (map) {
            return this.setDeclarations.remove(name);
        }
    }
}

