/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.set;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapSchemaStaticSetFormulaEvaluationCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.IOlapLambdaProcessingEnabled;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapDynamicSetFormulaEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSetFormulaEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapStaticSetFormulaEvaluationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import java.io.Serializable;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapSetDeclaration
implements IOlapLambdaProcessingEnabled<OlapSetDeclaration> {
    private final boolean select;
    @Nullable
    private final String cubeName;
    private final String setName;
    private final boolean sessionScoped;
    private final boolean dynamicEvaluation;
    private final String mdx;
    private final OlapInstr formula;
    @Nullable
    private final String displayFolder;
    @Nullable
    private final String description;

    public OlapSetDeclaration(boolean select, @Nullable String cubeName, String setName, boolean sessionScoped, boolean dynamicEvaluation, String mdx, OlapInstr<?> formula, @Nullable String displayFolder, @Nullable String description) {
        this.select = select;
        this.cubeName = cubeName;
        this.setName = setName;
        this.sessionScoped = sessionScoped;
        this.dynamicEvaluation = dynamicEvaluation;
        this.mdx = mdx;
        this.formula = formula;
        this.displayFolder = displayFolder;
        this.description = description;
    }

    @Override
    public OlapSetDeclaration forkForParallelLambdaProcessing() {
        return this;
    }

    public boolean isForSelect() {
        return this.select;
    }

    @Nullable
    public String getCubeName() {
        return this.cubeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getQualifiedSetName() {
        String scope = this.isForSelect() ? "[select]" : (this.isSessionScoped() ? "[session]" : "[schema]");
        String mode = this.isDynamicEvaluation() ? "[dynamic]" : "[static]";
        Object cube = this.cubeName != null ? "[" + CdMdxUtils.escape((String)this.cubeName) + "]." : "";
        return scope + mode + (String)cube + "[" + CdMdxUtils.escape((String)this.setName) + "]";
    }

    public String getSetCaption(Locale locale, OlapSchema schema) {
        OlapSchemaLocalization localization = schema.getLocalization();
        String caption = localization.getSchemaSetCaption(locale, this);
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            caption = this.getSetName();
        }
        return caption;
    }

    @Nullable
    public String getSetDescription(Locale locale, OlapSchema schema) {
        OlapSchemaLocalization localization = schema.getLocalization();
        String descriptionL = localization.getSchemaSetDescription(locale, this);
        if (CdStringUtils.isNullOrBlank((String)descriptionL)) {
            descriptionL = this.description;
        }
        return descriptionL;
    }

    public boolean isSessionScoped() {
        return this.sessionScoped;
    }

    public boolean isDynamicEvaluation() {
        return this.dynamicEvaluation;
    }

    public String getMdx() {
        return this.mdx;
    }

    public OlapInstr<?> getFormula() {
        return this.formula;
    }

    @Nullable
    public String getDisplayFolder() {
        return this.displayFolder;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapTupleSet evaluate(OlapEvaluationContext evaluationContext) {
        OlapTupleSet<? extends OlapTuple> olapTupleSet;
        S_MdxStatementRequestContextRef clusterContextRef;
        block9: {
            OlapSetFormulaEvaluationContext evalContext;
            clusterContextRef = null;
            if (this.dynamicEvaluation) {
                evalContext = this.setupDynamicEvaluationContext(evaluationContext);
            } else {
                evalContext = this.setupStaticEvaluationContext(evaluationContext);
                OlapMdxStatementExecutionContext sContext = evalContext.getStatementExecutionContext();
                clusterContextRef = sContext.createClusterContext();
                OlapCube cube = sContext.getNullableCube();
                if (cube != null && !cube.isFactless()) {
                    sContext.createClusterStaticContext();
                }
            }
            try {
                olapTupleSet = this.executeFormula(evalContext);
                if (this.dynamicEvaluation) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (!this.dynamicEvaluation) {
                        OlapMdxStatementExecutionContext sContext = evalContext.getStatementExecutionContext();
                        sContext.performHousekeeping();
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    evaluationContext.deleteMdxStatementContext(clusterContextRef);
                    throw throwable2;
                }
            }
            OlapMdxStatementExecutionContext sContext = evalContext.getStatementExecutionContext();
            sContext.performHousekeeping();
        }
        evaluationContext.deleteMdxStatementContext(clusterContextRef);
        return olapTupleSet;
    }

    private OlapSetFormulaEvaluationContext setupDynamicEvaluationContext(OlapEvaluationContext evaluationContext) {
        OlapMdxStatementExecutionContext sContext = evaluationContext.getStatementExecutionContext();
        OlapNameContext nameContext = sContext.getNameContext();
        OlapCube cube = sContext.getCube();
        OlapCube underlying = cube.getUnderlying();
        if (this.cubeName != null && !underlying.getName(nameContext).equals(this.cubeName)) {
            throw new OlapEvaluationException(evaluationContext, OlapErrorCode.CUBE_DYNAMIC_SET_MISMATCH, new Serializable[]{evaluationContext.getSchema().getName(), this.getQualifiedSetName(), this.cubeName, underlying.getName(nameContext)});
        }
        return new OlapDynamicSetFormulaEvaluationContext(sContext, cube);
    }

    private OlapSetFormulaEvaluationContext setupStaticEvaluationContext(OlapEvaluationContext evaluationContext) {
        OlapCube cube;
        OlapMdxStatementExecutionContext sContext = evaluationContext.getStatementExecutionContext();
        OlapSchema schema = sContext.getSchema();
        if (this.cubeName == null) {
            if (this.isForSelect()) {
                OlapCube currentCube = evaluationContext.getCube();
                cube = currentCube.getUnderlying();
            } else {
                @Nullable OlapCube cube_ = schema.getFirstNullableCube();
                cube = cube_ == null ? new OlapSchemaStaticSetFormulaEvaluationCube(schema) : cube_;
            }
        } else {
            cube = this.resolveSpecifiedCube(evaluationContext);
        }
        OlapProperties requestProperties = !this.sessionScoped ? sContext.getRequestContext().getOlapEngineProperties() : sContext.getRequestProperties();
        OlapMdxStatementWithCubeSelectExecutionContext statementContext = new OlapMdxStatementWithCubeSelectExecutionContext(sContext.getRequestContext(), requestProperties, sContext.getAnnotations(), sContext.getInstrExecListener(), schema, cube, true);
        statementContext.adoptMdxExtraExecutionLOCK(sContext);
        return new OlapStaticSetFormulaEvaluationContext((OlapMdxStatementExecutionContext)statementContext, cube);
    }

    private OlapCube resolveSpecifiedCube(OlapEvaluationContext evaluationContext) {
        if (this.cubeName == null) {
            throw new CdProgrammingException("internal error: missing cube name");
        }
        OlapCube cube = evaluationContext.lookupCubeByMdxIdentifier(this.cubeName);
        if (cube == null) {
            throw new OlapEvaluationException(evaluationContext, OlapErrorCode.CUBE_UNKNOWN_SET, new Serializable[]{evaluationContext.getSchema().getName(), this.cubeName, this.getQualifiedSetName()});
        }
        return cube;
    }

    private OlapTupleSet<? extends OlapTuple> executeFormula(OlapSetFormulaEvaluationContext context) {
        try {
            long startMS = System.currentTimeMillis();
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] set [" + this.setName + "] formula.evaluation [dynamic:" + context.isDynamicSetEvaluation() + "] started"));
            OlapEntity entity = this.formula.execute(context);
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] set [" + this.setName + "] formula.evaluation done in " + CdTimeUtils.formatMillisEx((long)startMS)));
            GFContext gContext = context.createGFContext();
            IOlapPrepareContext pContext = gContext.getPrepareContext();
            if (entity.isToSetApplicable(pContext)) {
                startMS = System.currentTimeMillis();
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] set [" + this.setName + "] formula.toSet evaluation started"));
                OlapTupleSet<? extends OlapTuple> set = entity.toSet(pContext);
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] set [" + this.setName + "] formula.toSet evaluation done (" + set.fastEstimatedSize() + ") in " + CdTimeUtils.formatMillisEx((long)startMS)));
                startMS = System.currentTimeMillis();
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] set [" + this.setName + "] set.materialization started"));
                int limit = context.getTidyMaxAxisMaterializeCount();
                OlapTupleSet<? extends OlapTuple> namedSet = set.convertToMaterializedNamedSet(context, this.setName, limit);
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] set [" + this.setName + "] set.materialization done (" + namedSet.fastEstimatedSize() + ") in " + CdTimeUtils.formatMillisEx((long)startMS)));
                if (context.isDynamicSetEvaluation()) {
                    OlapSlicerFilter slicerTupleFilter = context.getSlicerTupleFilterForSetFiltering();
                    return OlapSetFactory.instance(slicerTupleFilter, namedSet);
                }
                return namedSet;
            }
            throw new OlapEvaluationException(this.formula.getLocationRange(), OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"set(" + this.getQualifiedSetName() + ")", entity.getFriendlyTypeName()});
        }
        catch (OlapEvaluationException ex) {
            if (!this.select) {
                throw ex.wrapMessage("set( " + this.getQualifiedSetName() + " ) : ");
            }
            throw ex;
        }
    }

    public String toString() {
        return this.getQualifiedSetName();
    }
}

