/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.statistics;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellAxis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class OlapMdxStatementEvalStatistics {
    private final AtomicLong tupleAggregateCount = new AtomicLong(0L);
    private final AtomicLong tupleAggregateSetCount = new AtomicLong(0L);
    private final AtomicLong setEvaluatorCount = new AtomicLong(0L);
    private final List<CellCache> cellCaches = new ArrayList<CellCache>();
    private final Map<String, CalcMemberCache> calcMemberCaches = new ConcurrentHashMap<String, CalcMemberCache>();
    private final Map<Integer, Boolean> fastNonEmptyApplied = new ConcurrentHashMap<Integer, Boolean>();

    public void registerAxes(OlapCellAxis[] axes) {
        for (int ii = 0; ii < axes.length; ++ii) {
            OlapCellAxis axis = axes[ii];
            this.fastNonEmptyApplied.put(ii, axis.isFastNonEmpty());
        }
    }

    public void merge(OlapMdxStatementEvalStatistics from) {
        this.tupleAggregateCount.addAndGet(from.tupleAggregateCount.get());
        this.tupleAggregateSetCount.addAndGet(from.tupleAggregateSetCount.get());
    }

    public void onCellsCached(long size, long get, long miss) {
        this.cellCaches.add(new CellCache(size, get, miss));
    }

    public List<CellCache> cellCaches() {
        return this.cellCaches;
    }

    public void onCalcMemberCached(OlapCalculatedMember member, long size, long get, long miss) {
        String uniqueName = member.getUniqueName(OlapNameContext.DEFAULT_VALUES);
        this.calcMemberCaches.put(uniqueName, new CalcMemberCache(uniqueName, member.getNameX(), size, get, miss));
    }

    public Map<String, CalcMemberCache> calcMemberCaches() {
        return this.calcMemberCaches;
    }

    public void onTupleAggregateDecrement() {
        this.tupleAggregateCount.decrementAndGet();
    }

    public void onTupleAggregate(GFFactsEvalTuple tuple, OlapMeasureMember measure) {
        this.tupleAggregateCount.incrementAndGet();
    }

    public long tupleAggregateCount() {
        return this.tupleAggregateCount.get();
    }

    public void onTupleAggregateSet(IOlapMembers iTuple, GFFactsEvalTuple tuple, OlapMeasureMember measure) {
        this.tupleAggregateSetCount.incrementAndGet();
    }

    public long tupleAggregateSetCount() {
        return this.tupleAggregateSetCount.get();
    }

    public void onSetEvaluatorCreated() {
        this.setEvaluatorCount.incrementAndGet();
    }

    public long setEvaluatorCount() {
        return this.setEvaluatorCount.get();
    }

    public boolean isFastNonEmptyApplied(int axis) {
        Boolean applied = this.fastNonEmptyApplied.get(axis);
        return applied != null && applied != false;
    }

    public static class CellCache {
        public long size;
        public long get;
        public long miss;

        public CellCache(long size, long get, long miss) {
            this.size = size;
            this.get = get;
            this.miss = miss;
        }
    }

    public static class CalcMemberCache {
        public final String uniqueName;
        public final String name;
        public long size;
        public long get;
        public long miss;

        public CalcMemberCache(String uniqueName, String name, long size, long get, long miss) {
            this.uniqueName = uniqueName;
            this.name = name;
            this.size = size;
            this.get = get;
            this.miss = miss;
        }
    }
}

