/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context.sets;

import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.eval.set.OlapSetInfo;
import org.jetbrains.annotations.Nullable;

public class OlapSetEvaluation {
    private final OlapSetDeclaration set;
    @Nullable
    private final OlapTupleSet<? extends OlapTuple> eval;
    @Nullable
    private final RuntimeException error;

    public OlapSetEvaluation(OlapSetDeclaration set, @Nullable OlapTupleSet<? extends OlapTuple> eval, @Nullable RuntimeException error) {
        this.set = set;
        this.eval = eval;
        this.error = error;
        if (eval == null && error == null) {
            throw new RuntimeException("internal error: no eval & no error for set [" + set.getQualifiedSetName() + "]");
        }
        if (eval != null && error != null) {
            throw new RuntimeException("internal error: eval & error for set [" + set.getQualifiedSetName() + "]");
        }
    }

    @Nullable
    public OlapSetInfo getInfo() {
        if (this.eval != null) {
            String name = this.eval.getName();
            OlapTupleDimensionality dimensionality = this.eval.getTupleDimensionality();
            long estimatedSize = this.eval.fastEstimatedSize();
            return new OlapSetInfo(name, dimensionality, estimatedSize != -1L ? Long.valueOf(estimatedSize) : null);
        }
        return null;
    }

    public OlapTupleSet<? extends OlapTuple> getEval() {
        if (this.error != null) {
            throw this.error;
        }
        return this.eval;
    }

    @Nullable
    public RuntimeException getError() {
        return this.error;
    }

    public String toString() {
        return this.set.getSetName() + (this.error != null ? " [error]" : "");
    }
}

