/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapSubSelectCube;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSelectCalculatedMemberManager;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.CONDITIONALLY_THREAD_SAFE)
public class OlapMdxStatementWithCubeSelectExecutionContext
extends OlapMdxStatementExecutionContext {
    private final boolean withEval;
    private final OlapMemberPropertyEvalContext memberPropertyEvalContext;
    private final OlapNameContext cubeNameContext;
    private final OlapSelectCalculatedMemberManager calcMemberManager;
    private OlapCube cube;

    public OlapMdxStatementWithCubeSelectExecutionContext(OlapEngineRequestContext requestContext, OlapProperties requestProperties, @Nullable MdxAnnotation[] annotations, @Nullable OlapInstrExecListener instrExecListener, OlapSchema schema, OlapCube cube, boolean withEval) {
        this(requestContext, requestProperties, annotations, instrExecListener, null, schema, cube, withEval, null);
    }

    protected OlapMdxStatementWithCubeSelectExecutionContext(OlapEngineRequestContext requestContext, OlapProperties requestProperties, @Nullable MdxAnnotation[] annotations, @Nullable OlapInstrExecListener instrExecListener, @Nullable OlapSelectCalculatedMemberManager calcMemberManager, OlapSchema schema, OlapCube cube, boolean withEval, @Nullable List<OlapTupleSet<? extends OlapTuple>> filterByInfo) {
        super(requestContext, requestProperties, annotations, instrExecListener, schema, filterByInfo);
        if (calcMemberManager != null) {
            this.calcMemberManager = calcMemberManager;
        } else if (cube != null) {
            this.calcMemberManager = new OlapSelectCalculatedMemberManager(cube.getCalcMemberManager());
        } else {
            OlapCubeCalculatedMemberManager cubeCalcMemberManager = new OlapCubeCalculatedMemberManager("empty-calc-measures", schema.getCalcMemberManager());
            this.calcMemberManager = new OlapSelectCalculatedMemberManager(cubeCalcMemberManager);
        }
        this.withEval = withEval;
        this.cube = cube;
        IOlapDimensionsPermission dimensionsPermissions = this.getDimensionsPermissions();
        this.cubeNameContext = dimensionsPermissions.getNamingContext(requestContext.getNameContext());
        this.memberPropertyEvalContext = this.createMemberPropertyEvalContext(this.cubeNameContext, dimensionsPermissions, cube.getName(this.cubeNameContext));
    }

    @Override
    public String getUsage() {
        return "expression [cube:" + this.getCube().getName(this.getNameContext()) + "]";
    }

    @Override
    public OlapSelectCalculatedMemberManager getCalcMemberManager() {
        return this.calcMemberManager;
    }

    @Override
    public IOlapCalculatedMembers getCalcMemberManagerForLookup() {
        OlapEngineSessionContext sessionContext = this.getSessionContext();
        return sessionContext.getCalcMemberManagerForLookup(this.getSchema(), this.calcMemberManager);
    }

    public void onMultiCellsEvaluationStarted() {
    }

    public void resetCubeForSubSelect(OlapSubSelectCube cube) {
        this.cube = cube;
    }

    @Override
    public boolean isWithEval() {
        return this.withEval;
    }

    @Override
    public OlapCube getCube() {
        return this.cube;
    }

    @Override
    @Nullable
    public OlapCube getNullableCube() {
        return this.getCube();
    }

    @Override
    public OlapMemberPropertyEvalContext getMemberPropertyEvalContext() {
        return this.memberPropertyEvalContext;
    }

    @Override
    public OlapNameContext getNameContext() {
        return this.cubeNameContext;
    }
}

