/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.collection.CdPair;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextInitData;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef_;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef_;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.context.MdxHousekeeper;
import crazydev.iccube.olap.eval.select.context.OlapMdxExtraExecutionLock;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapFastCrossjoinContext
implements IOlapCancellingContext {
    private final AtomicBoolean hackForNonEmptyX = new AtomicBoolean(false);
    private final int initialNonEmptyMaxRow;
    private final S_FastCrossjoinContextRef clusterContextRef;
    private final OlapMdxStatementExecutionContext sContext;
    private final IOlapEvaluationExceptionContext eContext;
    private final S_NonEmptyBehavior nonEmptyBehavior;
    private final boolean parallelProcessing;
    @Nullable
    private OlapMdxExtraExecutionLock mtEvalLock;

    public OlapFastCrossjoinContext(OlapMdxStatementExecutionContext sContext, IOlapEvaluationExceptionContext eContext, S_NonEmptyBehavior nonEmptyBehavior) {
        this(sContext, eContext, nonEmptyBehavior, true);
    }

    private OlapFastCrossjoinContext(OlapMdxStatementExecutionContext sContext, IOlapEvaluationExceptionContext eContext, S_NonEmptyBehavior nonEmptyBehavior, boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
        this.clusterContextRef = new S_FastCrossjoinContextRef(this);
        this.sContext = sContext;
        this.eContext = eContext;
        this.nonEmptyBehavior = nonEmptyBehavior;
        this.initialNonEmptyMaxRow = sContext.getInitialNonEmptyMaxRow();
    }

    public OlapProperties getRequestProperties() {
        return this.sContext.getRequestProperties();
    }

    public boolean acquireParallelExecutor() {
        if (this.parallelProcessing && this.mtEvalLock == null) {
            this.mtEvalLock = this.sContext.acquireMdxExtraExecutionLock();
        }
        return this.mtEvalLock != null;
    }

    public void releaseParallelExecutor() {
        if (this.mtEvalLock != null) {
            this.sContext.releaseMdxExtraExecutionLock(this.mtEvalLock);
            this.mtEvalLock = null;
        }
    }

    @Override
    public boolean isCancelling() {
        return this.sContext.isCancelling();
    }

    public boolean isForTidyEvaluation() {
        return this.sContext.isForTidyEvaluation();
    }

    @Override
    public void assertNotCancelling(String message) {
        this.sContext.assertNotCancelling(message);
    }

    public void registerHousekeeper(MdxHousekeeper housekeeper) {
        this.sContext.registerHousekeeper(housekeeper);
    }

    public OlapFastCrossjoinContext newInstanceForCrossjoinIterator() {
        OlapFastCrossjoinContext ctxt = new OlapFastCrossjoinContext(this.sContext, this.eContext, this.nonEmptyBehavior);
        if (this.hackForNonEmptyX.get()) {
            ctxt.hackForNonEmptyX();
        }
        return ctxt;
    }

    public String __debug() {
        return "";
    }

    public S_FastCrossjoinContextRef getClusterContextRef() {
        return this.clusterContextRef;
    }

    public OlapMdxStatementExecutionContext getStatementContext() {
        return this.sContext;
    }

    public int getInternalTupleListCountCJ() {
        IOlapEvaluationExceptionContext iOlapEvaluationExceptionContext = this.eContext;
        if (iOlapEvaluationExceptionContext instanceof GFContext) {
            GFContext gContext = (GFContext)iOlapEvaluationExceptionContext;
            return gContext.getInternalTupleListCountCJ();
        }
        return this.sContext.getInternalTupleListCountCJ();
    }

    public IOlapEvaluationExceptionContext getErrorContext() {
        return this.eContext;
    }

    public OlapTupleDimensionalityCache getTupleDimensionalityCache() {
        return this.sContext.getTupleDimensionalityCache();
    }

    @Nullable
    public OlapInstrExecListener getInstrExecListener() {
        return this.sContext.getInstrExecListener();
    }

    public void logOnCompleted(Logger logger) {
    }

    public List<CjBitmapHelper.CjBitmap> fastcrossjoin_init(List<List<OlapTuple>> tuples, OlapTupleDimensionality cjTupleDimensionality, int limitSize) {
        this.createClusterContext();
        List<S_FactTuplesDef> clusterTuples = tuples.stream().map(OlapFastCrossjoinContext::tranform).collect(Collectors.toList());
        OlapMdxStatementExecutionContext sContext = this.getStatementContext();
        S_MdxSessionContextRef sessionContextRef = sContext.getSessionContext().getClusterContextRef();
        S_MdxStatementRequestContextRef mdxStatementContextRef = sContext.getClusterContextRef();
        OlapEngineRequestContext requestContext = sContext.getRequestContext();
        M_LocalCluster cluster = requestContext.getCluster();
        List<CjBitmapHelper.CjBitmap> bitmaps = cluster.fastcrossjoin_init(sessionContextRef, mdxStatementContextRef, this.clusterContextRef, this.nonEmptyBehavior, cjTupleDimensionality, clusterTuples, limitSize);
        return bitmaps;
    }

    public void fastcrossjoin_initReduce(CjBitmapHelper.CjBitmap isNotEmpty, int tupleListindex, int start, int end) {
        this.createClusterContext();
        OlapMdxStatementExecutionContext sContext = this.getStatementContext();
        S_MdxSessionContextRef sessionContextRef = sContext.getSessionContext().getClusterContextRef();
        S_MdxStatementRequestContextRef mdxStatementContextRef = sContext.getClusterContextRef();
        OlapEngineRequestContext requestContext = sContext.getRequestContext();
        M_LocalCluster cluster = requestContext.getCluster();
        cluster.fastcrossjoin_initReduce(sessionContextRef, mdxStatementContextRef, this.clusterContextRef, this.nonEmptyBehavior, isNotEmpty, tupleListindex, start, end);
    }

    public CdPair<List<CjBitmapHelper.CjTupleListReducer>, Integer> fastcrossjoin_reduce(int tupleListindex, List<CjBitmapHelper.CjTupleListReducer> tuplesReducer, OlapTuple filterMembers) {
        if (filterMembers.isCalculated() || filterMembers.isAll()) {
            return new CdPair(tuplesReducer, (Object)0);
        }
        OlapMdxStatementExecutionContext sContext = this.getStatementContext();
        S_MdxSessionContextRef sessionContextRef = sContext.getSessionContext().getClusterContextRef();
        S_MdxStatementRequestContextRef mdxStatementContextRef = sContext.getClusterContextRef();
        OlapEngineRequestContext requestContext = sContext.getRequestContext();
        M_LocalCluster cluster = requestContext.getCluster();
        S_FactTupleDef_ s_filterMembers = new S_FactTupleDef_(filterMembers);
        CdPair<List<CjBitmapHelper.CjTupleListReducer>, Integer> bitmaps = cluster.fastcrossjoin_reduce(sessionContextRef, mdxStatementContextRef, this.clusterContextRef, this.nonEmptyBehavior, tupleListindex, tuplesReducer, s_filterMembers);
        return bitmaps;
    }

    private static S_FactTuplesDef tranform(List<? extends S_FactTupleDef> tuples) {
        return new S_FactTuplesDef_(tuples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClusterContext() {
        S_FastCrossjoinContextRef s_FastCrossjoinContextRef = this.clusterContextRef;
        synchronized (s_FastCrossjoinContextRef) {
            if (this.clusterContextRef.isCreated()) {
                return;
            }
            OlapMdxStatementExecutionContext sContext = this.getStatementContext();
            S_MdxSessionContextRef sessionContextRef = sContext.getSessionContext().getClusterContextRef();
            S_MdxStatementRequestContextRef mdxStatementContextRef = sContext.getClusterContextRef();
            OlapEngineRequestContext requestContext = sContext.getRequestContext();
            M_LocalCluster cluster = requestContext.getCluster();
            cluster.createFastCrossjoinContext(sessionContextRef, new S_FastCrossjoinContextInitData(mdxStatementContextRef, this.clusterContextRef));
        }
    }

    public OlapDimensionality toDimensionality(OlapTupleDimensionality iterTupleDimensionality) {
        return this.getStatementContext().getSchema().toDimensionality(iterTupleDimensionality);
    }

    public boolean isNonEmptyZero() {
        return this.nonEmptyBehavior.isZero();
    }

    public boolean hasNonEmpty() {
        if (this.nonEmptyBehavior.isTransparent()) {
            throw new RuntimeException("internal error: crossjoin w/ transparent non-empty behavior!");
        }
        return !this.nonEmptyBehavior.getNodes().isEmpty();
    }

    public String logNonEmptyBehavior() {
        return this.nonEmptyBehavior.toString();
    }

    public int getInitialNonEmptyMaxRow() {
        if (this.hackForNonEmptyX.get()) {
            return -1;
        }
        return this.initialNonEmptyMaxRow;
    }

    public void hackForNonEmptyX() {
        this.hackForNonEmptyX.set(true);
    }

    public int getNeCjThreadCount() {
        return this.sContext.getNeCjThreadCount();
    }

    public int getNeCjMaxPreCalculated() {
        return this.sContext.getNeCjMaxPreCalculated();
    }

    public int getNeCjMaxPreCalculatedTuples() {
        return this.sContext.getNeCjMaxPreCalculatedTuples();
    }

    public boolean isNeCjAsyncActivated() {
        return this.sContext.isNeCjAsyncActivated();
    }

    public boolean isNeCjParallelActivated() {
        return this.sContext.isNeCjParallelActivated();
    }
}

