/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.cache.statement.OlapMemberFilterCacheManager;
import crazydev.iccube.olap.eval.cache.statement.OlapStatementCacheManager;
import crazydev.iccube.olap.eval.cache.statement.OlapTupleFilterCacheManager;
import crazydev.iccube.olap.eval.catmember.OlapRequestCategoryMemberManager;
import crazydev.iccube.olap.eval.catmember.OlapSessionCategoryMemberManager;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainTupleFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsCluster;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.method.OlapModuleMethodsRepository;
import crazydev.iccube.olap.eval.select.context.OlapCalcMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapConstrainedEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContextKind;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluation;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationController;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationToken;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationTokenKind;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.eval.subselect.dimension.OlapCurrentTupleFilter;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.OlapServerCancelledRequestException;
import crazydev.iccube.request.log.OlapRequestId;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_COMPATIBLE)
public abstract class OlapEvaluationContext
extends OlapInstrExecutionContext {
    protected final OlapMdxStatementExecutionContext statementExecutionContext;
    private final boolean isInSubQuery;
    protected OlapCalcMemberEvaluationContext calcMemberEvaluationContext;
    private OlapMemberFilterCacheManager memberFilterCacheManager;
    private OlapTupleFilterCacheManager tupleFilterCacheManager;

    protected OlapEvaluationContext(OlapMdxStatementExecutionContext statementExecutionContext, boolean isInSubQuery) {
        OlapInstr instr = statementExecutionContext.peekCurrentInstruction();
        if (instr != null) {
            this.pushCurrentInstruction(instr);
        }
        this.statementExecutionContext = statementExecutionContext;
        this.memberFilterCacheManager = null;
        this.tupleFilterCacheManager = null;
        this.calcMemberEvaluationContext = null;
        this.isInSubQuery = isInSubQuery;
    }

    protected OlapEvaluationContext(OlapEvaluationContext vcontext) {
        OlapInstr instr = vcontext.peekCurrentInstruction();
        if (instr != null) {
            this.pushCurrentInstruction(instr);
        }
        this.statementExecutionContext = vcontext.statementExecutionContext;
        this.memberFilterCacheManager = null;
        this.tupleFilterCacheManager = null;
        this.calcMemberEvaluationContext = null;
        this.isInSubQuery = vcontext.isInSubQuery;
    }

    public OlapEvaluationContext forkForParallelLambdaProcessing() {
        OlapEvaluationContext fork = this.doForkForParallelLambdaProcessing();
        fork.doSetupForParallelLambdaProcessing(this);
        return fork;
    }

    protected OlapEvaluationContext doForkForParallelLambdaProcessing() {
        throw new RuntimeException("internal error: inconsistent parallel lambda processing ( " + this.getUsage() + " )");
    }

    protected void doSetupForParallelLambdaProcessing(OlapEvaluationContext from) {
        OlapInstr instr = from.peekCurrentInstruction();
        if (instr != null) {
            this.pushCurrentInstruction(instr);
        }
        if (this.statementExecutionContext != from.statementExecutionContext) {
            throw new RuntimeException("internal error: inconsistent parallel lambda processing setup");
        }
        if (this.isInSubQuery != from.isInSubQuery) {
            throw new RuntimeException("internal error: inconsistent parallel lambda processing setup");
        }
    }

    public CdXmlaCaller getXmlaCaller() {
        return this.statementExecutionContext.getXmlaCaller();
    }

    @Override
    public OlapRequestId getRequestId() {
        return this.statementExecutionContext.getRequestId();
    }

    @Override
    public boolean isCancelling() {
        return this.statementExecutionContext.isCancelling();
    }

    @Override
    public void assertNotCancelling(String message) {
        this.statementExecutionContext.assertNotCancelling(message);
    }

    @Override
    public String getUsage() {
        return "";
    }

    public boolean isForAuthExpression() {
        return false;
    }

    public OlapEvaluationContextKind getKind() {
        return OlapEvaluationContextKind.UNKNOWN;
    }

    public OlapMdxStatementExecutionContext getStatementExecutionContext() {
        return this.statementExecutionContext;
    }

    public void doNotUseResultCache() {
        this.statementExecutionContext.doNotUseResultCache();
    }

    public void markForDrilldownStop() {
        this.statementExecutionContext.markForDrilldownStop();
    }

    protected OlapMemberFilterCacheManager getOrCreateMemberFilterCacheManager() {
        if (this.memberFilterCacheManager == null) {
            OlapStatementCacheManager statementCacheManager = this.statementExecutionContext.getStatementCacheManager();
            this.memberFilterCacheManager = statementCacheManager.getOrCreateMemberFilterCacheManager(this);
        }
        return this.memberFilterCacheManager;
    }

    protected OlapTupleFilterCacheManager getOrCreateTupleFilterCacheManager() {
        if (this.tupleFilterCacheManager == null) {
            OlapStatementCacheManager statementCacheManager = this.statementExecutionContext.getStatementCacheManager();
            this.tupleFilterCacheManager = statementCacheManager.getOrCreateTupleFilterCacheManager(this);
        }
        return this.tupleFilterCacheManager;
    }

    @Override
    public Locale getLocale() {
        return this.statementExecutionContext.getLocale();
    }

    public Locale getLocaleForFormattingNumeric(Locale locale) {
        return this.statementExecutionContext.getLocaleForFormattingNumeric(locale);
    }

    public boolean isInSubQuery() {
        return this.isInSubQuery;
    }

    public boolean isCellPropertyRequested(OlapCellProperty property) {
        return false;
    }

    @Override
    @Nullable
    public OlapInstrExecListener getInstrExecListener() {
        return this.statementExecutionContext.getInstrExecListener();
    }

    public String getUserName() {
        return this.statementExecutionContext.getUserName();
    }

    public OlapEngineRequestContext getRequestContext() {
        return this.statementExecutionContext.getRequestContext();
    }

    public OlapProperties getRequestProperties() {
        return this.statementExecutionContext.getRequestProperties();
    }

    public OlapMemberPropertyManager getMemberPropertyManager() {
        return this.getSchema().getMemberPropertyManager();
    }

    public OlapSchema getSchema() {
        return this.statementExecutionContext.getSchema();
    }

    public IOlapSchemaPermission getSchemaPermissions() {
        return this.statementExecutionContext.getSchemaPermissions();
    }

    public IOlapSchemaPermission getSchemaPermissionsWithoutPerspective() {
        return this.statementExecutionContext.getSchemaPermissionsWithoutPerspective();
    }

    public IOlapDimensionsPermission getDimensionsPermissions() {
        return this.getSchemaPermissions().getDimensionsPermissions(this.getCube());
    }

    public IOlapDimensionsPermission getDimensionsPermissionsWithoutPerspective() {
        return this.getSchemaPermissionsWithoutPerspective().getDimensionsPermissions(this.getCube());
    }

    public IOlapDimensionPermission getDimensionPermissions(OlapDimension dimension) {
        IOlapDimensionsPermission permissions = this.getDimensionsPermissions();
        return permissions.getDimensionPermissions(dimension);
    }

    public IOlapDimensionPermission getDimensionPermissionsWithoutPerspective(OlapDimension dimension) {
        IOlapDimensionsPermission permissions = this.getDimensionsPermissionsWithoutPerspective();
        return permissions.getDimensionPermissions(dimension);
    }

    public IOlapHierarchyPermission getHierarchyPermissions(OlapHierarchy hierarchy) {
        IOlapDimensionPermission permissions = this.getDimensionPermissions(hierarchy.getDimension());
        return permissions.getHierarchyPermission(hierarchy);
    }

    public IOlapHierarchyPermission getHierarchyPermissionsWithoutPerspective(OlapHierarchy hierarchy) {
        IOlapDimensionPermission permissions = this.getDimensionPermissionsWithoutPerspective(hierarchy.getDimension());
        return permissions.getHierarchyPermission(hierarchy);
    }

    public abstract OlapCube getCube();

    public String getUnderlyingCubeName(OlapNameContext nameContext) {
        return this.statementExecutionContext.getCube().getName(nameContext);
    }

    public OlapCalcMemberEvaluationContext asCalcMemberContext() {
        if (this.calcMemberEvaluationContext == null) {
            this.calcMemberEvaluationContext = new OlapCalcMemberEvaluationContext(this);
        } else {
            this.calcMemberEvaluationContext.clearCurrentInstruction();
            OlapInstr instr = this.peekCurrentInstruction();
            if (instr != null) {
                this.calcMemberEvaluationContext.pushCurrentInstruction(instr);
            }
        }
        return this.calcMemberEvaluationContext;
    }

    public OlapConstrainedEvaluationContext createConstrainedExecutionContext(OlapFunction function) {
        return new OlapConstrainedEvaluationContext(this, function);
    }

    @Nullable
    public OlapEntity lookupCurrent(String key) {
        return null;
    }

    @Nullable
    public OlapTupleSet lookupAsNamedSet(String identifier) {
        return null;
    }

    protected OlapNonScalarEntity lookupCubeEntityByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        OlapEntityIdentifier[] resolvedIdentifier = new OlapEntityIdentifier[]{identifier};
        OlapCube resolvedCube = this.resolveCubeForLookupEntityByMdxIdentifier(resolvedIdentifier);
        IOlapSchemaPermission schemaPermission = this.getSchemaPermissionsWithoutPerspective();
        IOlapDimensionsPermission dimensionsPermission = schemaPermission.getDimensionsPermissions(resolvedCube);
        OlapRequestCategoryMemberManager manager = this.getRequestCategoryMemberManager();
        List<OlapHierarchy> requestHierarchies = manager.getAllCategoryMemberHierarchies(this.getSchema());
        OlapSessionCategoryMemberManager sessionCategoryMemberManager = this.getSessionCategoryMemberManager();
        List<OlapHierarchy> sessionHierarchies = sessionCategoryMemberManager.getAllCategoryMemberHierarchies(this.getSchema());
        OlapNonScalarEntity entity = resolvedCube.lookupEntityByMdxIdentifier(this.getNameContext(), dimensionsPermission, requestHierarchies, sessionHierarchies, resolvedIdentifier[0]);
        return entity;
    }

    public OlapRequestCategoryMemberManager getRequestCategoryMemberManager() {
        return this.statementExecutionContext.getRequestCategoryMemberManager();
    }

    public OlapSessionCategoryMemberManager getSessionCategoryMemberManager() {
        return this.statementExecutionContext.getSessionCategoryMemberManager();
    }

    protected OlapCube resolveCubeForLookupEntityByMdxIdentifier(OlapEntityIdentifier[] resolvedIdentifier) {
        OlapNameContext nameContext;
        IOlapSchemaPermission schemaPermission;
        OlapSchema schema;
        OlapCube cube;
        OlapEntityIdentifierPart firstPart;
        String cubeName;
        OlapEntityIdentifier identifier = resolvedIdentifier[0];
        if (identifier.getPartCount() > 1 && (cubeName = (firstPart = identifier.getFirstPart()).asName()) != null && (cube = (schema = this.getSchema()).lookupCubeByName(schemaPermission = this.getSchemaPermissions(), nameContext = this.getNameContext(), cubeName)) != null) {
            resolvedIdentifier[0] = identifier.subIdentifier(1);
            return cube;
        }
        OlapCube cube2 = this.getCube();
        return cube2;
    }

    public boolean isDimensionOrHierarchyPrefix(OlapEntityIdentifier identifier) {
        OlapCube cube = this.getCube();
        return cube.isDimensionOrHierarchyPrefix(this.getDimensionsPermissions(), this.getNameContext(), identifier);
    }

    public OlapNonScalarEntity lookupUserDefinedMeasureByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        OlapCalculatedMemberManager manager = this.statementExecutionContext.getCalcMemberManager();
        OlapUserMeasureMember measure = manager == null ? null : manager.lookupUserMeasure(this.getNameContext(), identifier);
        return measure == null ? OlapNullEntity.INSTANCE : measure;
    }

    public List<OlapUserMeasureMember> lookupUserDefinedMeasures(@Nullable OlapMemberFilter filter) {
        OlapCalculatedMemberManager manager = this.statementExecutionContext.getCalcMemberManager();
        List<OlapUserMeasureMember> measures = manager.lookupUserMeasures(filter);
        return measures;
    }

    public OlapNonScalarEntity lookupCalculatedMemberByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        IOlapCalculatedMembers manager = this.statementExecutionContext.getCalcMemberManagerForLookup();
        OlapMember cmember = manager == null ? null : manager.lookupCalculatedMember(this.getNameContext(), identifier);
        return cmember == null ? OlapNullEntity.INSTANCE : cmember;
    }

    public List<OlapMember> getAllCalculatedMembers() {
        IOlapCalculatedMembers manager = this.statementExecutionContext.getCalcMemberManagerForLookup();
        if (manager == null) {
            return Collections.emptyList();
        }
        return manager.getVisibleCalculatedMembers(this.getMemberFilter());
    }

    public List<OlapDimension> getAllDimensions() {
        return this.statementExecutionContext.getAllDimensions();
    }

    public int getHierarchyCount() {
        return this.statementExecutionContext.getHierarchyCount();
    }

    @Nullable
    public OlapHierarchy getDefaultTimeHierarchy() {
        return this.statementExecutionContext.getDefaultTimeHierarchy();
    }

    public OlapNonScalarEntity lookupHierarchy(int position) {
        return this.statementExecutionContext.lookupHierarchy(position);
    }

    public OlapMemberPropertyEvalContext getMemberPropertyEvalContext() {
        return this.statementExecutionContext.getMemberPropertyEvalContext();
    }

    @Nullable
    public OlapResSlicer getSlicer() {
        return this.statementExecutionContext.getSlicer();
    }

    public OlapTupleSet<OlapTuple> getAxis(int number) {
        return this.statementExecutionContext.getAxis(number);
    }

    @Nullable
    public OlapTupleSet<OlapTuple> getSubSelectAxis(int number) {
        return this.statementExecutionContext.getSubSelectAxis(number);
    }

    @Nullable
    public OlapTupleSet<OlapTuple> getSlicerSet() {
        OlapResSlicer slicer = this.getStatementExecutionContext().getSlicer();
        OlapTupleSet<OlapTuple> slicerSet = slicer == null ? null : slicer.getForSlicerFunction();
        return slicerSet;
    }

    public OlapNonScalarEntity lookupSetByMdxIdentifier(OlapEntityIdentifier identifier) {
        OlapSetDeclaration setDeclaration = this.statementExecutionContext.lookupSetDeclaration(identifier);
        if (setDeclaration != null) {
            if (OlapLoggers.MDX_EVALUATION_SET.isDebugEnabled()) {
                OlapLoggers.MDX_EVALUATION_SET.debug((Object)("[set-evaluation] lookupSetByMdxIdentifier:" + identifier.asString() + " @" + identifier.debug() + " => " + setDeclaration.getSetName()));
            }
            return this.getOrEvaluateSetDeclaration(setDeclaration);
        }
        return OlapNullEntity.INSTANCE;
    }

    private OlapTupleSet<? extends OlapTuple> getOrEvaluateSetDeclaration(OlapSetDeclaration set) {
        OlapTupleSet<? extends OlapTuple> eval = this.safeGetOrEvaluateSetDeclaration(set);
        return eval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapTupleSet<? extends OlapTuple> safeGetOrEvaluateSetDeclaration(OlapSetDeclaration set) {
        OlapSetEvaluationController controller = this.statementExecutionContext.getSetEvaluationController();
        controller.push(this, set);
        try {
            OlapTupleSet<? extends OlapTuple> olapTupleSet = this.safeGetOrEvaluateSetDeclaration(controller, set);
            return olapTupleSet;
        }
        finally {
            controller.pop(set);
        }
    }

    private OlapTupleSet<? extends OlapTuple> safeGetOrEvaluateSetDeclaration(OlapSetEvaluationController controller, OlapSetDeclaration set) {
        if (OlapLoggers.MDX_EVALUATION_SET.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION_SET.debug((Object)("[set-evaluation] safeGetOrEvaluateSetDeclaration:" + set.getSetName() + " started"));
        }
        try {
            OlapSetEvaluationTokenKind kind;
            block12: while (true) {
                OlapSetEvaluationToken token = controller.getEvaluationToken(this, set);
                kind = token.getKind();
                if (OlapLoggers.MDX_EVALUATION_SET.isDebugEnabled()) {
                    OlapLoggers.MDX_EVALUATION_SET.debug((Object)("[set-evaluation] safeGetOrEvaluateSetDeclaration:" + set.getSetName() + " [" + String.valueOf((Object)kind) + "]"));
                }
                switch (kind) {
                    case AVAILABLE: {
                        OlapSetEvaluation eval = token.getEvaluation();
                        if (eval == null) {
                            throw new RuntimeException("internal error: unexpected missing set evaluation [" + set.getQualifiedSetName() + "]");
                        }
                        OlapTupleSet<? extends OlapTuple> olapTupleSet = eval.getEval();
                        return olapTupleSet;
                    }
                    case EVALUATING: {
                        controller.await(this, set);
                        continue block12;
                    }
                    case EVALUATE: {
                        OlapSetEvaluation eval = controller.evaluate(this, set);
                        OlapTupleSet<? extends OlapTuple> olapTupleSet = eval.getEval();
                        return olapTupleSet;
                    }
                }
                break;
            }
            try {
                throw new RuntimeException("internal error: unexpected token [" + String.valueOf((Object)kind) + "]");
            }
            catch (InterruptedException ex) {
                OlapServerCancelledRequestException error = new OlapServerCancelledRequestException("interrupted while accessing the set [" + set.getQualifiedSetName() + "]");
                controller.onEvaluationInterrupted(set, error);
                throw error;
            }
        }
        finally {
            if (OlapLoggers.MDX_EVALUATION_SET.isDebugEnabled()) {
                OlapLoggers.MDX_EVALUATION_SET.debug((Object)("[set-evaluation] safeGetOrEvaluateSetDeclaration:" + set.getSetName() + " done"));
            }
        }
    }

    public Collection<OlapCube> getCubes() {
        return this.getSchema().getCubes(this.getSchemaPermissions());
    }

    public final OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, int lookup, OlapEntityIdentifier identifier) {
        OlapNonScalarEntity entity;
        if ((lookup & OlapMdxEntityLookupKinds.USER_DEFINED_MEASURE) == OlapMdxEntityLookupKinds.USER_DEFINED_MEASURE && !(entity = this.lookupUserDefinedMeasureByMdxIdentifier(nameContext, identifier)).isMdxNull()) {
            return entity;
        }
        if ((lookup & OlapMdxEntityLookupKinds.CALC_MEMBER) == OlapMdxEntityLookupKinds.CALC_MEMBER && !(entity = this.lookupCalculatedMemberByMdxIdentifier(nameContext, identifier)).isMdxNull()) {
            return entity;
        }
        if ((lookup & OlapMdxEntityLookupKinds.SET) == OlapMdxEntityLookupKinds.SET && !(entity = this.lookupSetByMdxIdentifier(identifier)).isMdxNull()) {
            return entity;
        }
        if ((lookup & OlapMdxEntityLookupKinds.CUBE_ENTITY) == OlapMdxEntityLookupKinds.CUBE_ENTITY && !(entity = this.lookupCubeEntityByMdxIdentifier(nameContext, identifier)).isMdxNull()) {
            return entity;
        }
        return OlapNullEntity.INSTANCE;
    }

    @Nullable
    public final OlapCube lookupCubeByMdxIdentifier(String name) {
        OlapSchema schema = this.statementExecutionContext.getSchema();
        OlapEngineRequestContext context = this.statementExecutionContext.getRequestContext();
        return context.getCubeByName(this.getNameContext(), schema, name);
    }

    @Nullable
    public final OlapMember getNullableCurrentMemberFromSlicer(OlapHierarchy hierarchy, @Nullable OlapResSlicer slicer) {
        OlapMember current = slicer != null ? slicer.getMember(this, hierarchy) : null;
        return current;
    }

    protected OlapInstr<?> compileMdxExpression(OlapCompilationContext ccontext, String mdx, String mdxHash) throws IOException, CdMdxScannerException, MdxParserException {
        MdxParsingContext pcontext = new MdxParsingContext(ccontext.getProperties(), ccontext.getFunctionRepository(), this.getSchema().getFunctionRepositorySnapshot());
        MdxExpression expr = MdxParser.parseValueExpression(pcontext, mdx, mdxHash);
        return ccontext.compile(expr);
    }

    public OlapEntityIdentifier compileIdentifier(String name) throws CdMdxScannerException, MdxParserException {
        try {
            OlapEngineComponent olapEngine = this.getRequestContext().getOlapEngineComponent();
            OlapModuleMethodsRepository moduleMethodsRepository = olapEngine.getModuleMethodsRepository();
            OlapCompilationContext context = new OlapCompilationContext(this.getXmlaCaller(), this.getRequestContext().getMdxDefaultRequestedCellProperties(), this.getRequestProperties(), olapEngine.getFunctionRepository(), moduleMethodsRepository);
            OlapInstr<?> instr = this.compileMdxExpression(context, name, "exec-?");
            if (instr instanceof OlapIdentifierInstr) {
                OlapIdentifierInstr id = (OlapIdentifierInstr)instr;
                return id.getId();
            }
            throw new OlapEvaluationException(this, OlapErrorCode.MDX_IDENTIFIER_ERROR, new Serializable[]{name});
        }
        catch (IOException ex) {
            throw new RuntimeException("IO Error!", ex);
        }
    }

    public void assertEntityUsage(OlapEntityIdentifier id, OlapNonScalarEntity entity) {
        if (entity.isDynamicCategory()) {
            this.assertDynamicCategoryUsage(id, entity);
        }
    }

    public void assertDynamicCategoryUsage(OlapEntityIdentifier id, OlapNonScalarEntity entity) {
    }

    public void addVisualTotalsCluster(OlapVisualTotalsCluster cluster) {
        this.statementExecutionContext.addVisualTotalsCluster(cluster);
    }

    @Nullable
    public OlapMemberFilter getSchemaPermissionsMemberFilter() {
        return this.getDimensionsPermissions().getMemberFilter();
    }

    @Nullable
    public OlapTupleFilter getSchemaPermissionsMemberTupleFilter() {
        return this.getDimensionsPermissions().getMemberTupleFilter();
    }

    @Nullable
    public OlapSlicerFilter getSlicerTupleFilter() {
        return this.statementExecutionContext.getSlicerTupleFilter();
    }

    @Nullable
    public OlapSlicerFilter getSlicerTupleFilterForSetFiltering() {
        return this.statementExecutionContext.getSlicerTupleFilter();
    }

    @Nullable
    public OlapSubSelectTupleFilter getSubSelectTupleFilter() {
        OlapCube cube = this.getCube();
        return cube.getSubSelectTupleFilter();
    }

    @Nullable
    public OlapMemberFilter getMemberFilter() {
        return this.getOrCreateMemberFilterCacheManager().getFilter();
    }

    public OlapTupleFilter getMemberTupleFilter() {
        return this.getSchemaPermissionsMemberTupleFilter();
    }

    @Nullable
    public OlapChainMemberFilter createChainMemberFilter() {
        return OlapChainMemberFilter.create(this.getSchemaPermissionsMemberFilter(), this.getSubSelectTupleFilter());
    }

    @Nullable
    public OlapTupleFilter getTupleFilter() {
        return this.getOrCreateTupleFilterCacheManager().getFilter();
    }

    @Nullable
    public OlapChainTupleFilter createChainTupleFilter() {
        return OlapChainTupleFilter.create(this.getSchemaPermissionsMemberTupleFilter(), this.getSubSelectTupleFilter());
    }

    @Nullable
    public OlapChainTupleFilter createChainTupleFilterForExisting(@Nullable OlapCurrentTupleFilter currentTupleFilterForExisting) {
        return OlapChainTupleFilter.create(this.createCurrentTupleFilterForExisting(currentTupleFilterForExisting));
    }

    @Nullable
    protected OlapCurrentTupleFilter createCurrentTupleFilterForExisting(@Nullable OlapCurrentTupleFilter currentTupleFilterForExisting) {
        return currentTupleFilterForExisting;
    }

    public boolean isStatic() {
        return false;
    }

    public GFEvalTupleVisibility getEvalTupleVisibility() {
        return GFEvalTupleVisibility.DYNAMIC;
    }

    public boolean isAcceptingFunctionCall(OlapFunction function) {
        if (!this.isInSubQuery()) {
            return !this.getForbiddenFunctions().contains(function.getClass());
        }
        return !this.getSubQueryForbiddenFunctions().contains(function.getClass());
    }

    protected Set<Class<? extends OlapFunction>> getForbiddenFunctions() {
        return Collections.emptySet();
    }

    protected Set<Class<? extends OlapFunction>> getSubQueryForbiddenFunctions() {
        return Collections.emptySet();
    }

    @Nullable
    public Object getStatementCachedObject(Object key) {
        return this.statementExecutionContext.getCachedObject(key);
    }

    public void addStatementCachedObject(Object key, Object formatter) {
        this.statementExecutionContext.addCachedObject(key, formatter);
    }

    public boolean isCellEvaluation() {
        return false;
    }

    @Nullable
    public OlapTuple getCellTupleForDrillthrough() {
        return null;
    }

    public boolean isDrillthroughActive() {
        if (!this.isCellEvaluation()) {
            return false;
        }
        return this.statementExecutionContext.isDrillthroughActive();
    }

    @Nullable
    public OlapFunction lookupFunction(String name) {
        return this.statementExecutionContext.lookupFunction(name);
    }

    @Nullable
    public OlapDeclaredFunction lookupDeclaredFunction(String name) {
        return this.statementExecutionContext.lookupDeclaredFunction(name);
    }

    @Nullable
    public OlapFunction lookupRegularFunction(String name) {
        return this.statementExecutionContext.lookupFunction(name);
    }

    @Override
    public OlapNameContext getNameContext() {
        return this.statementExecutionContext.getNameContext();
    }

    public int getTidyMaxAxisMaterializeCount() {
        return this.statementExecutionContext.getMaxSetMaterializeCount();
    }

    @Nullable
    public IOlapBigBrotherMgr getServerMonitoring() {
        if (this.getRequestContext().getApplicationPermissions().isBigBrotherEnabled()) {
            return this.getRequestContext().getApplicationContext().getBigBrotherMgr();
        }
        return null;
    }

    public OlapEngineSessionContext getSessionContext() {
        return this.statementExecutionContext.getSessionContext();
    }

    @Nullable
    public OlapIntrinsicMemberProperty getIntrinsicProperty(String name) {
        return this.getMemberPropertyManager().getIntrinsicProperty(name);
    }

    public OlapTupleDimensionalityCache getTupleDimensionalityCache() {
        return this.getStatementExecutionContext().getTupleDimensionalityCache();
    }

    public GFContext createGFContext() {
        throw new RuntimeException("internal error: missing GF context for : ( " + this.getUsage() + " ) - " + this.getClass().getName());
    }

    public void deleteMdxStatementContext(@Nullable S_MdxStatementRequestContextRef mdxStatementContextRef) {
        this.statementExecutionContext.deleteClusterContext(mdxStatementContextRef);
    }
}

