/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsCluster;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapConstrainedEvaluationContext
extends OlapEvaluationContext {
    private final OlapEvaluationContext decorated;
    private final OlapFunction function;

    public OlapConstrainedEvaluationContext(OlapEvaluationContext context, OlapFunction function) {
        super(context.statementExecutionContext, context.isInSubQuery());
        this.decorated = context;
        this.function = function;
    }

    @Override
    public String getUsage() {
        return "constrained";
    }

    @Override
    public OlapCube getCube() {
        return this.decorated.getCube();
    }

    @Override
    protected OlapNonScalarEntity lookupCubeEntityByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        return this.decorated.lookupCubeEntityByMdxIdentifier(nameContext, identifier);
    }

    @Override
    public boolean isDimensionOrHierarchyPrefix(OlapEntityIdentifier identifier) {
        return this.decorated.isDimensionOrHierarchyPrefix(identifier);
    }

    @Override
    public boolean isConstrained() {
        return true;
    }

    @Override
    public <T> T onConstrainedViolation() {
        throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)this, this.function.getName(), OlapErrorCode.CONSTRAINED_VIOLATED, new Serializable[0]);
    }

    @Override
    public OlapConstrainedEvaluationContext createConstrainedExecutionContext(OlapFunction function) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public String getUserName() {
        return (String)this.onConstrainedViolation();
    }

    @Override
    public OlapEntityIdentifier compileIdentifier(String name) {
        return (OlapEntityIdentifier)this.onConstrainedViolation();
    }

    @Override
    public OlapMemberPropertyEvalContext getMemberPropertyEvalContext() {
        return (OlapMemberPropertyEvalContext)this.onConstrainedViolation();
    }

    @Override
    public int getHierarchyCount() {
        this.onConstrainedViolation();
        return -1;
    }

    @Override
    @Nullable
    public OlapHierarchy getDefaultTimeHierarchy() {
        return (OlapHierarchy)this.onConstrainedViolation();
    }

    @Override
    public List<OlapDimension> getAllDimensions() {
        return (List)this.onConstrainedViolation();
    }

    @Override
    public OlapNonScalarEntity lookupHierarchy(int position) {
        return (OlapNonScalarEntity)this.onConstrainedViolation();
    }

    @Override
    public OlapNonScalarEntity lookupUserDefinedMeasureByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        return this.decorated.lookupUserDefinedMeasureByMdxIdentifier(nameContext, identifier);
    }

    @Override
    public List<OlapUserMeasureMember> lookupUserDefinedMeasures(@Nullable OlapMemberFilter filter) {
        return this.decorated.lookupUserDefinedMeasures(filter);
    }

    @Override
    public OlapNonScalarEntity lookupCalculatedMemberByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        return this.decorated.lookupCalculatedMemberByMdxIdentifier(nameContext, identifier);
    }

    @Override
    public OlapNonScalarEntity lookupSetByMdxIdentifier(OlapEntityIdentifier identifier) {
        return this.decorated.lookupSetByMdxIdentifier(identifier);
    }

    @Override
    public List<OlapMember> getAllCalculatedMembers() {
        return (List)this.onConstrainedViolation();
    }

    @Override
    public OlapTupleSet<OlapTuple> getAxis(int number) {
        return (OlapTupleSet)this.onConstrainedViolation();
    }

    @Override
    public void addVisualTotalsCluster(OlapVisualTotalsCluster cluster) {
        this.onConstrainedViolation();
    }

    @Override
    public boolean isStatic() {
        return this.decorated.isStatic();
    }

    @Override
    public GFEvalTupleVisibility getEvalTupleVisibility() {
        return this.decorated.getEvalTupleVisibility();
    }
}

