/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContextKind;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.List;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_COMPATIBLE)
public class OlapCellEvaluationContext
extends OlapEvaluationContext {
    private final OlapCellsEvaluationContext cellsEvalContext;
    private OlapTuple cellTupleForDrillthrough;

    public OlapCellEvaluationContext(OlapCellsEvaluationContext cellsEvalContext) {
        super(cellsEvalContext.getStatementContext(), false);
        this.cellsEvalContext = cellsEvalContext;
    }

    @Override
    public OlapEvaluationContextKind getKind() {
        return OlapEvaluationContextKind.CELL;
    }

    @Override
    public String getUsage() {
        return "cell";
    }

    @Override
    public boolean isDimensionalityCheck() {
        OlapProperties props = this.getRequestProperties();
        return props.isDimensionalityCheck();
    }

    @Override
    public boolean isCellEvaluation() {
        return true;
    }

    @Override
    public OlapTuple getCellTupleForDrillthrough() {
        return this.cellTupleForDrillthrough;
    }

    public void setCellTupleForDrillthrough(OlapTuple cellTupleForDrillthrough) {
        this.cellTupleForDrillthrough = cellTupleForDrillthrough;
    }

    public boolean isNonEmptyActive() {
        return this.cellsEvalContext.isNonEmptyActive();
    }

    @Override
    public OlapCube getCube() {
        return this.cellsEvalContext.getCube();
    }

    public void onNewCell(OlapTuple[] cell, int[] si) {
        this.cellsEvalContext.onNewCell(cell, si);
    }

    public OlapSelectStatementExecutionContext getStatementContext() {
        return this.cellsEvalContext.getStatementContext();
    }

    public List<OlapCellProperty> getRequestedCellProperties() {
        return this.cellsEvalContext.getRequestedCellProperties();
    }

    @Override
    public boolean isCellPropertyRequested(OlapCellProperty property) {
        return this.cellsEvalContext.isCellPropertyRequested(property);
    }

    @Override
    protected OlapEvaluationContext doForkForParallelLambdaProcessing() {
        return new OlapCellEvaluationContext(this.cellsEvalContext);
    }
}

