/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsFunction;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContextKind;
import crazydev.iccube.olap.eval.subselect.dimension.OlapCurrentTupleFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_COMPATIBLE)
public class OlapCalcMemberEvaluationContext
extends OlapEvaluationContext {
    private static final Set<Class<? extends OlapFunction>> FORBIDDEN_FUNCTIONS = new HashSet<Class>(Arrays.asList(OlapVisualTotalsFunction.class));
    private final OlapEvaluationContext vcontext;
    private final OlapCube cube;

    public OlapCalcMemberEvaluationContext(OlapEvaluationContext vcontext) {
        super(vcontext);
        this.vcontext = vcontext;
        this.cube = vcontext.statementExecutionContext.getCube();
    }

    @Override
    public OlapEvaluationContextKind getKind() {
        return OlapEvaluationContextKind.CALC_MEMBER;
    }

    @Override
    public String getUsage() {
        return "calculated member (" + this.vcontext.getUsage() + ")";
    }

    @Override
    public boolean isDimensionalityCheck() {
        OlapProperties props = this.getRequestProperties();
        return props.isDimensionalityCheck();
    }

    @Override
    public boolean isCellEvaluation() {
        return this.vcontext.isCellEvaluation();
    }

    @Override
    public boolean isCellPropertyRequested(OlapCellProperty property) {
        return this.vcontext.isCellPropertyRequested(property);
    }

    @Override
    public OlapTuple getCellTupleForDrillthrough() {
        return this.vcontext.getCellTupleForDrillthrough();
    }

    @Override
    public boolean isAcceptingFunctionCall(OlapFunction function) {
        return super.isAcceptingFunctionCall(function) && this.vcontext.isAcceptingFunctionCall(function);
    }

    @Override
    protected Set<Class<? extends OlapFunction>> getForbiddenFunctions() {
        return FORBIDDEN_FUNCTIONS;
    }

    @Override
    public OlapCalcMemberEvaluationContext asCalcMemberContext() {
        return this;
    }

    @Override
    public OlapCube getCube() {
        return this.cube.getUnderlying();
    }

    @Override
    @Nullable
    public OlapSlicerFilter getSlicerTupleFilterForSetFiltering() {
        return null;
    }

    @Override
    @Nullable
    public OlapChainMemberFilter createChainMemberFilter() {
        return OlapChainMemberFilter.create(this.getSchemaPermissionsMemberFilter());
    }

    @Override
    @Nullable
    public OlapChainTupleFilter createChainTupleFilter() {
        return OlapChainTupleFilter.create(this.getSchemaPermissionsMemberTupleFilter());
    }

    @Override
    @Nullable
    public OlapChainTupleFilter createChainTupleFilterForExisting(@Nullable OlapCurrentTupleFilter currentTupleFilterForExisting) {
        return OlapChainTupleFilter.create(this.createCurrentTupleFilterForExisting(currentTupleFilterForExisting), this.cube.getSubSelectTupleFilter(), this.getSlicerTupleFilter());
    }

    @Override
    public boolean isStatic() {
        return this.vcontext.isStatic();
    }

    @Override
    public GFEvalTupleVisibility getEvalTupleVisibility() {
        return this.vcontext.getEvalTupleVisibility();
    }

    @Override
    public final OlapEvaluationContext forkForParallelLambdaProcessing() {
        return new OlapCalcMemberEvaluationContext(this.vcontext.forkForParallelLambdaProcessing());
    }

    @Override
    protected OlapEvaluationContext doForkForParallelLambdaProcessing() {
        throw new RuntimeException("internal error: inconsistent parallel lambda processing ( " + this.getUsage() + " )");
    }
}

