/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxUserAnnotation;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapStatementInstr<CTXT extends OlapInstrExecutionContext>
extends OlapExecutedWithoutPreparedInstr<CTXT>
implements IExecuteStatementInstr {
    public OlapStatementInstr(OlapInstrLocationRange range) {
        super(range);
    }

    public abstract boolean requiresFacts();

    @Nullable
    public MdxAnnotation[] getAnnotations() {
        return null;
    }

    protected boolean isEmptyStatement() {
        return false;
    }

    @Override
    public boolean isResultCacheEnabled() {
        return false;
    }

    @Override
    public abstract IcCubeSchemaAccessLockMode getSchemaAccessLockMode();

    public final CTXT setupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema, boolean forBuilder) {
        String roleName;
        if (!this.isEmptyStatement() && !forBuilder) {
            IcCubeSchemaAccessLockMode mode = this.getSchemaAccessLockMode();
            requestContext.assertSchemaAccessLock(mode, schema.getName());
        }
        if ((roleName = this.setupActualRoleNameForImpersonation()) != null) {
            OlapPrincipal requestUser = requestContext.getUser();
            if (requestUser.isAdministrator()) {
                OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] impersonation requested for role '" + roleName + "'"));
                return this.setupExecutionContextForImpersonation(requestContext, properties, instrExecutionListener, schema, roleName);
            }
            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] impersonation for role '" + roleName + "' ignored ( requires administrator credentials - actual role is '" + requestUser.getRoleName() + "' )"));
        }
        return this.setupExecutionContextForRequestUser(requestContext, properties, instrExecutionListener, schema);
    }

    @Nullable
    protected String setupActualRoleNameForImpersonation() {
        String roleName = null;
        MdxAnnotation[] annotations = this.getAnnotations();
        if (annotations != null) {
            for (MdxAnnotation annotation : annotations) {
                if (!(annotation instanceof MdxUserAnnotation)) continue;
                MdxUserAnnotation userAnnotation = (MdxUserAnnotation)annotation;
                roleName = userAnnotation.getRoleName();
                break;
            }
        }
        return roleName;
    }

    protected CTXT setupExecutionContextForRequestUser(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        return this.doSetupExecutionContext(requestContext, properties, instrExecutionListener, schema);
    }

    protected CTXT setupExecutionContextForImpersonation(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema, String roleName) {
        OlapEngineRequestContext requestContext_ = requestContext.impersonate(roleName, null);
        OlapRolePermissions permissions_ = requestContext_.getCurrentPermissions();
        OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] impersonation : executing the MDX statement with role '" + permissions_.getRoleName() + "'"));
        return this.doSetupExecutionContext(requestContext_, properties, instrExecutionListener, schema);
    }

    protected CTXT doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        throw new CdDoNotCallMeProgrammingException();
    }
}

