/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;

public abstract class OlapScriptCommandStatementInstr<CTXT extends OlapInstrExecutionContext>
extends OlapStatementInstr<CTXT> {
    public OlapScriptCommandStatementInstr(OlapInstrLocationRange range) {
        super(range);
    }

    protected void assertAuthorizationForDropStatement(OlapMdxStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
    }

    protected void onScriptStatementApplied(OlapMdxStatementExecutionContext context, OlapSchema schema, boolean globalScope) {
        OlapEngineRequestContext requestContext = context.getRequestContext();
        if (requestContext.isScriptStatementAppliedDeactivated()) {
            return;
        }
        OlapScriptInformation information = this.asScriptInformation();
        if (globalScope) {
            this.backupScript(context, schema, information);
        }
        OlapEngineComponent engine = requestContext.getOlapEngineComponent();
        engine.scriptStatementApplied(requestContext, schema, information);
    }

    private void backupScript(OlapMdxStatementExecutionContext context, OlapSchema schema, OlapScriptInformation information) {
        if (schema.isBackuping()) {
            OlapEngineRequestContext requestContext = context.getRequestContext();
            M_BackupManager backupManager = requestContext.getOrCreateBackupManager();
            String script = information.getMdx();
            if (script == null) {
                OlapLoggers.BACKUP.error((Object)"[backup] execute script error - could not extract the MDX statement - backup ignored");
                return;
            }
            if (CdStringUtils.isNullOrBlank((String)script)) {
                OlapLoggers.BACKUP.warn((Object)"[backup] execute script - empty MDX statement - backup ignored");
                return;
            }
            backupManager.backupScript(schema, script);
        }
    }

    protected OlapScriptInformation asScriptInformation() {
        try {
            String mdx = this.getMdx();
            return new OlapScriptInformation(mdx);
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.error((Object)"[scripts] could not extract the MDX statement", (Throwable)ex);
            return new OlapScriptInformation(null);
        }
    }

    @Override
    public boolean requiresFacts() {
        return false;
    }
}

