/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class OlapCreateSetSelectInstr
extends OlapExecutedWithoutPreparedInstr<OlapSelectStatementExecutionContext> {
    @Nullable
    private final String cube;
    private final String name;
    private final boolean dynamicEvaluation;
    private final String mdx;
    private final OlapInstr formula;

    public OlapCreateSetSelectInstr(OlapInstrLocationRange range, @Nullable String cube, String name, boolean dynamicEvaluation, String mdx, OlapInstr formula) {
        super(range);
        this.cube = cube;
        this.name = name;
        this.dynamicEvaluation = dynamicEvaluation;
        this.mdx = mdx;
        this.formula = formula;
        this.formula.setParent(this);
    }

    @Override
    public String typeForError() {
        return "NAMED SET";
    }

    public String getName() {
        return this.name;
    }

    public OlapInstr getFormula() {
        return this.formula;
    }

    @Override
    public boolean isWorthProfiling() {
        return true;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    @Override
    protected OlapEntity doExecute(OlapSelectStatementExecutionContext context) {
        if (context.containsStatementSetDeclaration(this.name)) {
            OlapCreateSetSelectInstr.onInstrExecutionError(context, OlapErrorCode.DUPLICATED_NAMED_SET, new Serializable[]{this.name});
        }
        context.addStatementSetDeclaration(this.cube, this.name, this.dynamicEvaluation, this.mdx, this.formula);
        return OlapNullEntity.INSTANCE;
    }

    @Override
    public String toStringForDebugger() {
        return "WITH SET : " + this.name;
    }
}

