/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.OlapSelectCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateMeasureEvaluationContext;

public class OlapCreateMeasureSelectInstr
extends OlapExecutedWithoutPreparedInstr<OlapCreateMeasureEvaluationContext> {
    private final OlapInstrLocationRange idRange;
    private final boolean definedAtSelectStatementLevel;
    private final String measureName;
    private final OlapInstr formula;
    private final OlapCellProperties properties;

    public OlapCreateMeasureSelectInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, boolean definedAtSelectStatementLevel, String measureName, OlapInstr formula, OlapCellProperties properties) {
        super(range);
        this.idRange = idRange;
        this.definedAtSelectStatementLevel = definedAtSelectStatementLevel;
        this.measureName = measureName;
        this.formula = formula;
        this.formula.setParent(this);
        this.properties = properties;
    }

    @Override
    public String toStringForDebugger() {
        return "Measure : [" + this.measureName + "]";
    }

    @Override
    public String typeForError() {
        return "MEASURE";
    }

    public String getMeasureName() {
        return this.measureName;
    }

    public OlapInstr getFormula() {
        return this.formula;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    @Override
    protected OlapEntity doExecute(OlapCreateMeasureEvaluationContext context) {
        OlapCube cube = context.getCube();
        OlapHierarchy defaultTimeHierarchy = context.getDefaultTimeHierarchy();
        OlapUserMeasureMember measure = this.createUserMeasure(context, defaultTimeHierarchy, cube, this.definedAtSelectStatementLevel, this.measureName, this.formula, this.properties);
        OlapSelectCalculatedMemberManager manager = context.getSelectMeasureManager();
        manager.addUserMeasureIfNotContained(this.getLocationRange(), context.getNameContext(), measure);
        return measure;
    }
}

