/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.function.mdx.OlapConstDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.function.mdx.OlapStaticNoParamDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapStaticWithParamDeclaredFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.List;

public class OlapCreateFunctionSelectInstr
extends OlapExecutedWithoutPreparedInstr<OlapSelectStatementExecutionContext> {
    private final OlapInstrLocationRange idRange;
    private final boolean constant;
    private final boolean staticEvaluation;
    private final String name;
    private final List<OlapDeclaredFunctionParameter> argNames;
    private final OlapInstr body;
    private final boolean cached;

    public OlapCreateFunctionSelectInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, boolean constant, boolean staticEvaluation, String name, List<OlapDeclaredFunctionParameter> argNames, OlapInstr body, boolean cached) {
        super(range);
        this.idRange = idRange;
        this.constant = constant;
        this.staticEvaluation = staticEvaluation;
        this.name = name;
        this.argNames = argNames;
        this.body = body;
        this.body.setParent(this);
        this.cached = cached;
    }

    @Override
    public String typeForError() {
        return "FUNCTION";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.body.accept(v);
        }
    }

    public OlapDeclaredFunction getFunctionDeclaration() {
        OlapDeclaredFunction function = this.constant ? new OlapConstDeclaredFunction(this.name, this.body, this.cached) : (this.staticEvaluation ? (this.argNames.isEmpty() ? new OlapStaticNoParamDeclaredFunction(true, this.name, this.argNames, this.body, null, this.cached) : new OlapStaticWithParamDeclaredFunction(true, this.name, this.argNames, this.body, null, this.cached)) : new OlapDeclaredFunction(this.name, this.argNames, this.body));
        return function;
    }

    @Override
    protected OlapEntity doExecute(OlapSelectStatementExecutionContext context) {
        OlapDeclaredFunction function = this.getFunctionDeclaration();
        context.addDeclaredFunctionIfNotContained(this.idRange, function);
        return new OlapStringEntity(this.name);
    }

    @Override
    public String toStringForDebugger() {
        return "Function : " + this.name;
    }
}

