/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.cmember.OlapSelectCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapCalcCategoryMember;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;

public class OlapCreateCategoryMemberSelectInstr
extends OlapExecutedWithoutPreparedInstr<OlapCreateCategoryMemberEvaluationContext> {
    private final OlapInstrLocationRange idRange;
    private final OlapEntityIdentifier id;
    private final boolean dynamicEvaluation;
    private final boolean calculated;
    private final OlapInstr formula;
    private final OlapCategoryMemberProperties properties;

    public OlapCreateCategoryMemberSelectInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, OlapEntityIdentifier id, boolean dynamicEvaluation, boolean calculated, OlapInstr formula, OlapCategoryMemberProperties properties) {
        super(range);
        this.idRange = idRange;
        this.id = id;
        this.dynamicEvaluation = dynamicEvaluation;
        this.calculated = calculated;
        this.formula = formula;
        this.formula.setParent(this);
        this.properties = properties;
    }

    @Override
    public String toStringForDebugger() {
        return "Category Member : " + this.id.asString();
    }

    @Override
    public String typeForError() {
        return "CATEGORY MEMBER";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    public boolean isDynamicEvaluation() {
        return this.dynamicEvaluation;
    }

    @Override
    protected OlapEntity doExecute(OlapCreateCategoryMemberEvaluationContext context) {
        OlapAbstractCategoryMember categoryMember;
        OlapMdxStatementExecutionContext sContext = context.getStatementExecutionContext();
        if (!this.calculated) {
            categoryMember = this.createCategoryMember(context.getStatementExecutionContext(), OlapHierarchyScope.REQUEST, this.id, this.dynamicEvaluation, this.formula, this.properties);
        } else {
            OlapCalculatedMember calcMember = this.createFakeCalcMember(context);
            OlapMember parent = calcMember.getParent();
            String name = calcMember.getName(OlapNameContext.DEFAULT_VALUES);
            if (parent == null && (parent = calcMember.getHierarchy().getAllMember()) == null) {
                throw new RuntimeException("Category member needs to define a parent member (hierachy " + calcMember.getHierarchy().getNameX() + " does not define an ALL-MEMBER)");
            }
            categoryMember = new OlapCalcCategoryMember(sContext, (OlapInstr)this, OlapHierarchyScope.REQUEST, this.id, this.dynamicEvaluation, this.formula, this.properties, parent, name);
            OlapSelectCalculatedMemberManager selectCalcMemberManager = context.getSelectCalcMemberManager();
            selectCalcMemberManager.addIfNotContained(this.getLocationRange(), context.getNameContext(), categoryMember);
        }
        return categoryMember;
    }

    private OlapCalculatedMember createFakeCalcMember(OlapCreateCategoryMemberEvaluationContext context) {
        OlapCreateCalcMemberEvaluationContext cmContext = new OlapCreateCalcMemberEvaluationContext(context.getSelectStatementExecutionContext(), true);
        boolean definedAtSelectStatementLevel = true;
        long declarationOrder = -1L;
        OlapEntityIdentifier anchorId = this.createCalcMemberAnchorId();
        String name = this.id.getLastPartAsName();
        OlapInstr formula = this.formula;
        OlapCellProperties properties = new OlapCellProperties();
        String definedUniqueName = null;
        OlapCalculatedMember calcMember = OlapCreateCategoryMemberSelectInstr.createCalcMember(cmContext, true, -1L, this.idRange, anchorId, name, formula, properties, definedUniqueName);
        return calcMember;
    }

    private OlapEntityIdentifier createCalcMemberAnchorId() {
        OlapEntityIdentifier anchorId = this.id.getPartCount() == 1 ? new OlapEntityIdentifier("Measures") : this.id.subIdentifier(0, this.id.getPartCount() - 1);
        return anchorId;
    }

    public void setupDynamicLogic(OlapCreateCategoryMemberEvaluationContext context, OlapCategoryMember member) {
        if (!this.isDynamicEvaluation()) {
            throw new RuntimeException("internal error : inconsistent DYNAMIC category member evaluation : static member");
        }
        if (member.hasLogic()) {
            throw new RuntimeException("internal error : inconsistent DYNAMIC category member evaluation : multiple evaluation");
        }
        member.createRequestDynamicLogic(context.getStatementExecutionContext());
    }
}

