/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.OlapSelectCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberEvaluationContext;
import java.util.List;

public class OlapCreateCalcMemberSelectInstr
extends OlapExecutedWithoutPreparedInstr<OlapCreateCalcMemberEvaluationContext> {
    private final boolean definedAtSelectStatementLevel;
    private final MdxIdentifierExpression parsedId;
    private final String name;
    private final OlapEntityIdentifier anchorId;
    private final OlapInstrLocationRange idRange;
    private final OlapInstr formula;
    private final OlapCellProperties properties;
    private long declarationOrder;

    public OlapCreateCalcMemberSelectInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, boolean definedAtSelectStatementLevel, long declarationOrder, MdxIdentifierExpression parsedId, String name, OlapEntityIdentifier anchorId, OlapInstr formula, OlapCellProperties properties) {
        super(range);
        this.definedAtSelectStatementLevel = definedAtSelectStatementLevel;
        this.declarationOrder = declarationOrder;
        this.parsedId = parsedId;
        this.name = name;
        this.anchorId = anchorId;
        this.idRange = idRange;
        this.formula = formula;
        this.formula.setParent(this);
        this.properties = properties;
    }

    @Override
    public String toStringForDebugger() {
        return "Calc. Member : " + this.anchorId.toString() + ".[" + this.name + "]";
    }

    @Override
    public String typeForError() {
        return "CALCULATED MEMBER";
    }

    public String getName() {
        return this.name;
    }

    public int getVisible() {
        return this.properties.getVisible();
    }

    public int getSolveOrder() {
        return this.properties.getSolveOrder();
    }

    public OlapInstr getFormula() {
        return this.formula;
    }

    public List<OlapCellPropertyValue> getCellPropertyValues() {
        return this.properties.getCellPropertyValues();
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    @Override
    protected OlapEntity doExecute(OlapCreateCalcMemberEvaluationContext context) {
        String definedUniqueName = context.definedCalcMemberUniqueName(this.parsedId, false);
        OlapCalculatedMember calcMember = OlapCreateCalcMemberSelectInstr.createCalcMember(context, this.definedAtSelectStatementLevel, this.declarationOrder, this.idRange, this.anchorId, this.name, this.formula, this.properties, definedUniqueName);
        OlapSelectCalculatedMemberManager selectCalcMemberManager = context.getSelectCalcMemberManager();
        selectCalcMemberManager.addIfNotContained(this.getLocationRange(), context.getNameContext(), calcMember);
        return calcMember;
    }
}

