/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.olap.eval.execinstr.OlapAsNamedSetPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;

public class OlapAsNamedSetInstr
extends OlapExecutedWithPreparedInstr<OlapEvaluationContext> {
    private final String asName;
    private OlapInstr arg;

    public OlapAsNamedSetInstr(OlapInstrLocationRange range, OlapInstr arg, String asName) {
        super(range);
        this.asName = asName;
        this.setupArg(arg);
    }

    @Override
    public String typeForError() {
        return "AS NAMED SET";
    }

    @Override
    public String toStringForDebugger() {
        return this.arg.toStringForDebugger() + " AS " + this.asName;
    }

    private void setupArg(OlapInstr instr) {
        this.arg = instr;
        this.arg.setParent(this);
    }

    public String getAsName() {
        return this.asName;
    }

    public OlapInstr getArg() {
        return this.arg;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.arg.accept(v);
        }
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapPreparedInstr pArg = this.arg.prepare(context);
        OlapAsNamedSetPreparedInstr instr = new OlapAsNamedSetPreparedInstr(this, this.asName, pArg);
        context.pushAsNameSet(instr);
        return instr;
    }
}

