/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.script;

import crazydev.common.exception.ICdException;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.OlapResErrorMdxStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptRegularDataSet;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapScriptExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapScriptInstr
extends OlapExecutedWithoutPreparedInstr<OlapScriptExecutionContext>
implements IExecuteStatementInstr {
    private final String name;
    private final List<OlapStatementInstr> statements;

    public OlapScriptInstr(OlapInstrLocationRange range, String name) {
        this(range, name, new ArrayList<OlapStatementInstr>());
    }

    public OlapScriptInstr(OlapInstrLocationRange range, String name, List<OlapStatementInstr> statements) {
        this(range, name, statements, true);
    }

    private OlapScriptInstr(OlapInstrLocationRange range, String name, List<OlapStatementInstr> statements, boolean addIntoParent) {
        super(range);
        this.name = name;
        this.statements = statements;
        if (addIntoParent) {
            for (OlapStatementInstr statement : statements) {
                statement.setParent(this);
            }
        }
    }

    @Override
    public String typeForError() {
        return "SCRIPT";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            for (OlapStatementInstr statement : this.statements) {
                statement.accept(v);
            }
        }
    }

    public OlapScriptInstr asBuilderPhaseI() {
        ArrayList<OlapStatementInstr> phaseIstatement = new ArrayList<OlapStatementInstr>();
        for (OlapStatementInstr statement : this.statements) {
            if (statement.requiresFacts()) continue;
            phaseIstatement.add(statement);
        }
        return new OlapScriptInstr(this.getLocationRange(), this.name, phaseIstatement, false);
    }

    public OlapScriptInstr asBuilderPhaseII() {
        ArrayList<OlapStatementInstr> phaseIIstatement = new ArrayList<OlapStatementInstr>();
        for (OlapStatementInstr statement : this.statements) {
            if (!statement.requiresFacts()) continue;
            phaseIIstatement.add(statement);
        }
        return new OlapScriptInstr(this.getLocationRange(), this.name, phaseIIstatement, false);
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        if (this.statements.isEmpty()) {
            return IcCubeSchemaAccessLockMode.NONE;
        }
        for (OlapStatementInstr statement : this.statements) {
            if (statement.getSchemaAccessLockMode() != IcCubeSchemaAccessLockMode.WRITE) continue;
            return IcCubeSchemaAccessLockMode.WRITE;
        }
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    public boolean isResultCacheEnabled() {
        return false;
    }

    public OlapScriptExecutionContext setupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema, boolean forUX, boolean forBuilder, boolean forPhaseI) {
        if (!this.statements.isEmpty() && !forBuilder) {
            IcCubeSchemaAccessLockMode mode = this.getSchemaAccessLockMode();
            requestContext.assertSchemaAccessLock(mode, schema.getName());
        }
        return new OlapScriptExecutionContext(requestContext, properties, instrExecutionListener, schema, forUX, forBuilder, forPhaseI);
    }

    protected OlapResScriptDataSet doExecute(OlapScriptExecutionContext context) {
        ArrayList<OlapResStatementDataSet> statementResults = new ArrayList<OlapResStatementDataSet>();
        for (OlapStatementInstr statement : this.statements) {
            long startMS = System.currentTimeMillis();
            try {
                Object statementExecutionContext = statement.setupExecutionContext(context.getRequestContext(), context.getProperties(), context.getInstrExecListener(), context.getSchema(), context.isForBuilder());
                ((OlapInstrExecutionContext)statementExecutionContext).setIsForPhaseI(context.isForPhaseI());
                OlapResStatementDataSet statementResult = (OlapResStatementDataSet)statement.executeWithHousekeeping(statementExecutionContext);
                statementResult.setExecutionTimeMS(startMS);
                statementResults.add(statementResult);
            }
            catch (OlapException ex) {
                if (context.isForUX() && this.statements.size() > 1) {
                    statementResults.add(new OlapResErrorMdxStatementDataSet(this.name, context.getSchema().getName(), (ICdException)ex));
                    break;
                }
                throw ex;
            }
        }
        return new OlapResScriptRegularDataSet(this.name, context.getSchema().getName(), statementResults);
    }

    public List<OlapStatementInstr> getStatements() {
        return this.statements;
    }

    @Override
    public String toStringForDebugger() {
        return "SCRIPT";
    }
}

