/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.result;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.xmla.CdXmlaCellOrdinalHelper;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.scalar.OlapCellMeasureVectorScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapOtherNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapTruncatedString;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.loggers.OlapLoggers;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapEvalResult<TUPLE>
extends OlapOtherNonScalarAbstractEntity
implements IOlapEvalResult<TUPLE> {
    private final Object globalLOCK = new Object();
    private final int cellCountMax;
    private final int axisCount;
    private final boolean[] axesWithNonEmpty;
    private final AxisTuples<TUPLE>[] axesTuples;
    @Nullable
    private final NonEmptyValueMarker[] nonEmptyValueMarkers;
    private final Map<OlapEvalResultSi, OlapEvalResultCellValue> cellValues;

    public OlapEvalResult(int cellCountMax, boolean[] axesWithNonEmpty) {
        this.cellCountMax = cellCountMax;
        this.axisCount = axesWithNonEmpty.length;
        this.axesWithNonEmpty = axesWithNonEmpty;
        this.axesTuples = new AxisTuples[this.axisCount];
        for (int axis = 0; axis < this.axisCount; ++axis) {
            this.axesTuples[axis] = new AxisTuples(axis);
        }
        boolean hasNonEmpty = false;
        for (boolean withNonEmpty : axesWithNonEmpty) {
            if (!withNonEmpty) continue;
            hasNonEmpty = true;
            break;
        }
        if (hasNonEmpty) {
            this.nonEmptyValueMarkers = new NonEmptyValueMarker[this.axisCount];
            for (int axis = 0; axis < this.axisCount; ++axis) {
                this.nonEmptyValueMarkers[axis] = new NonEmptyValueMarker(axis);
            }
        } else {
            this.nonEmptyValueMarkers = null;
        }
        this.cellValues = new HashMap<OlapEvalResultSi, OlapEvalResultCellValue>();
    }

    @Override
    public boolean isForTidyEvaluation() {
        return false;
    }

    @Override
    public String getFriendlyTypeName() {
        return "cells";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAxisTuples(int axis, List<TUPLE> tuples) {
        for (TUPLE tuple : tuples) {
            if (!(tuple instanceof OlapTuple) || !((OlapTuple)tuple).isMeasureVector()) continue;
            throw new RuntimeException("internal error: inconsistent multi-column evaluation");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            AxisTuples<TUPLE> axisTuples = this.axesTuples[axis];
            for (int Si = 0; Si < tuples.size(); ++Si) {
                if (this.axesWithNonEmpty[axis]) continue;
                axisTuples.put(Si, tuples.get(Si));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellValue(IOlapEvaluationExceptionContext context, int rowIndex, TUPLE[] cellTuple, OlapEvalResultCellValue cellValue) {
        for (TUPLE tuple : cellTuple) {
            if (!(tuple instanceof OlapTuple) || !((OlapTuple)tuple).isMeasureVector()) continue;
            throw new RuntimeException("internal error: inconsistent multi-column evaluation");
        }
        OlapScalarEntity olapScalarEntity = cellValue.getScalarValue();
        if (olapScalarEntity instanceof OlapCellMeasureVectorScalarEntity) {
            throw new RuntimeException("internal error: inconsistent multi-column evaluation");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            int size;
            int axis;
            OlapEvalResultSi Si = cellValue.getCellSi();
            if (this.nonEmptyValueMarkers == null || !cellValue.isEmpty()) {
                if (this.cellCountMax > -1 && this.cellValues.size() > this.cellCountMax) {
                    throw new OlapEvaluationException(context, OlapErrorCode.SELECT_MAX_CELL_COUNT, Integer.valueOf(this.cellCountMax));
                }
                this.cellValues.put(Si, cellValue);
            }
            if (this.nonEmptyValueMarkers != null && !cellValue.isEmpty()) {
                for (axis = 0; axis < this.axisCount; ++axis) {
                    this.nonEmptyValueMarkers[axis].set(Si.getSi()[axis]);
                }
            }
            for (axis = 0; axis < this.axisCount; ++axis) {
                if (this.axesWithNonEmpty[axis]) {
                    if (cellValue.isEmpty()) continue;
                    this.axesTuples[axis].put(Si.getSi()[axis], cellTuple[axis]);
                    continue;
                }
                this.axesTuples[axis].put(Si.getSi()[axis], cellTuple[axis]);
            }
            if (OlapLoggers.MDX_EVALUATION.isDebugEnabled() && (size = this.cellValues.size()) > 0 && size % 100000 == 0) {
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] cells : " + size));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.cellValues.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tupleCount() {
        Object object = this.globalLOCK;
        synchronized (object) {
            int count = 0;
            for (AxisTuples<TUPLE> axis : this.axesTuples) {
                count += axis.size();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cellCount() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.cellValues.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processValues(IOlapCancellingContext context, ValueProcessor processor) {
        Object object = this.globalLOCK;
        synchronized (object) {
            int count = 0;
            for (Map.Entry<OlapEvalResultSi, OlapEvalResultCellValue> entry : this.cellValues.entrySet()) {
                if (++count % 100 == 0 && context.isCancelling()) break;
                processor.process(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Axes<TUPLE> computeAxesContent() {
        Object object = this.globalLOCK;
        synchronized (object) {
            List[] axesTuples = new List[this.axisCount];
            List[] axesSiMappings = new List[this.axisCount];
            for (int axis = 0; axis < this.axisCount; ++axis) {
                ArrayList axisTuples = new ArrayList();
                ArrayList<Integer> axisSiMappings = new ArrayList<Integer>();
                if (this.axesWithNonEmpty[axis]) {
                    this.createNonEmptyAxis(axisTuples, axisSiMappings, axis);
                } else {
                    this.createRegularAxis(axisTuples, axisSiMappings, axis);
                }
                axesTuples[axis] = axisTuples;
                axesSiMappings[axis] = axisSiMappings;
            }
            return new Axes(axesTuples, axesSiMappings);
        }
    }

    private void createNonEmptyAxis(List<TUPLE> axisTuples, List<Integer> axisSiMappings, int axis) {
        NonEmptyValueMarker axisNonEmptyValueMarkers = this.nonEmptyValueMarkers[axis];
        AxisTuples<TUPLE> axisNonEmptyTuples = this.axesTuples[axis];
        axisNonEmptyValueMarkers.createNonEmptyAxis(axisTuples, axisSiMappings, axisNonEmptyTuples);
    }

    private void createRegularAxis(List<TUPLE> axisTuples, List<Integer> axisSiMappings, int axis) {
        AxisTuples<TUPLE> axisNonEmptyTuples = this.axesTuples[axis];
        axisNonEmptyTuples.createRegularAxis(axisTuples, axisSiMappings);
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) throws OlapTruncatedString {
        return "";
    }

    @Override
    public String toStringForDebugger() {
        return this.getFriendlyTypeName();
    }

    @Override
    public String toStringForDebuggerAsValue() {
        return this.toStringForDebugger();
    }

    private static class AxisTuples<TUPLE> {
        final int axis;
        final Map<Integer, TUPLE> tuples;

        AxisTuples(int axis) {
            this.axis = axis;
            this.tuples = new HashMap<Integer, TUPLE>();
        }

        int size() {
            return this.tuples.size();
        }

        TUPLE get(int Si) {
            return this.tuples.get(Si);
        }

        void createRegularAxis(List<TUPLE> axisTuples, List<Integer> axisSiMappings) {
            int tuplesCount = this.size();
            for (int Si = 0; Si < tuplesCount; ++Si) {
                TUPLE tuple = this.tuples.get(Si);
                if (tuple == null) {
                    throw new RuntimeException("internal error: missing axis (" + this.axis + ") tuple (" + Si + ")");
                }
                axisTuples.add(tuple);
                axisSiMappings.add(Si);
            }
        }

        void put(int Si, TUPLE tuple) {
            this.tuples.put(Si, tuple);
        }
    }

    private static class NonEmptyValueMarker {
        final int axis;
        final Set<Integer> nonEmptyValueMarkers;

        NonEmptyValueMarker(int axis) {
            this.axis = axis;
            this.nonEmptyValueMarkers = new HashSet<Integer>();
        }

        void set(int Si) {
            this.nonEmptyValueMarkers.add(Si);
        }

        int cardinality() {
            return this.nonEmptyValueMarkers.size();
        }

        <TUPLE> void createNonEmptyAxis(List<TUPLE> axisTuples, List<Integer> axisSiMappings, AxisTuples<TUPLE> axisNonEmptyTuples) {
            int tuplesCount;
            int bitsCount = this.cardinality();
            if (bitsCount != (tuplesCount = axisNonEmptyTuples.size())) {
                throw new RuntimeException("internal error: inconsistent axis (" + this.axis + ") content [" + bitsCount + "][" + tuplesCount + "]");
            }
            ArrayList<Integer> nonEmptySIs = new ArrayList<Integer>(this.nonEmptyValueMarkers);
            Collections.sort(nonEmptySIs);
            for (Integer nonEmptySi : nonEmptySIs) {
                TUPLE tuple = axisNonEmptyTuples.get(nonEmptySi);
                if (tuple == null) {
                    throw new RuntimeException("internal error: missing axis (" + this.axis + ") tuple (" + nonEmptySi + ")");
                }
                axisTuples.add(tuple);
                axisSiMappings.add(nonEmptySi);
            }
        }
    }

    public static interface ValueProcessor {
        public void process(OlapEvalResultSi var1, OlapEvalResultCellValue var2);
    }

    public static class Axes<TUPLE> {
        private final List<TUPLE>[] axes;
        private final Int2IntOpenHashMap[] SiMappings;
        private final Int2IntOpenHashMap[] reverseSiMappings;
        private final CdXmlaCellOrdinalHelper ordinals;

        public Axes(List<TUPLE>[] axes, List<Integer>[] SiMappings) {
            this.axes = axes;
            this.SiMappings = new Int2IntOpenHashMap[SiMappings.length];
            this.reverseSiMappings = new Int2IntOpenHashMap[SiMappings.length];
            for (int idx = 0; idx < SiMappings.length; ++idx) {
                this.SiMappings[idx] = this.setupSiMapping(SiMappings[idx]);
                this.reverseSiMappings[idx] = this.setupReverseSiMapping(SiMappings[idx]);
            }
            int[] Uk = new int[SiMappings.length];
            for (int idx = 0; idx < Uk.length; ++idx) {
                Uk[idx] = SiMappings[idx].size();
            }
            this.ordinals = new CdXmlaCellOrdinalHelper(Uk);
        }

        private Int2IntOpenHashMap setupSiMapping(List<Integer> SiMapping) {
            Int2IntOpenHashMap mapping = new Int2IntOpenHashMap();
            int size = SiMapping.size();
            for (int idx = 0; idx < size; ++idx) {
                mapping.put(SiMapping.get(idx).intValue(), idx);
            }
            return mapping;
        }

        private Int2IntOpenHashMap setupReverseSiMapping(List<Integer> SiMapping) {
            Int2IntOpenHashMap mapping = new Int2IntOpenHashMap();
            int size = SiMapping.size();
            for (int idx = 0; idx < size; ++idx) {
                mapping.put(idx, SiMapping.get(idx).intValue());
            }
            return mapping;
        }

        public List<TUPLE> getAxis(int idx) {
            return this.axes[idx];
        }

        public Int2IntOpenHashMap getSiMapping(int idx) {
            return this.SiMappings[idx];
        }

        public CdXmlaCellOrdinalHelper getOrdinals() {
            return this.ordinals;
        }

        public int[] convert(int[] Si) {
            int[] newSi = new int[Si.length];
            for (int idx = 0; idx < newSi.length; ++idx) {
                newSi[idx] = Axes.convert(this.SiMappings[idx], Si[idx]);
            }
            return newSi;
        }

        public int[] reverseConvert(int[] Si) {
            int[] newSi = new int[Si.length];
            for (int idx = 0; idx < newSi.length; ++idx) {
                newSi[idx] = Axes.convert(this.reverseSiMappings[idx], Si[idx]);
            }
            return newSi;
        }

        public static int convert(Int2IntOpenHashMap mapping, int Si) {
            if (!mapping.containsKey(Si)) {
                throw new CdProgrammingException("inconsistent Si conversion [" + Si + "]");
            }
            return mapping.get(Si);
        }
    }
}

