/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.operator.unary;

import crazydev.iccube.olap.eval.execinstr.OlapLiteralPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapUnaryOperatorPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.operator.common.OlapOperator;
import crazydev.iccube.olap.eval.operator.common.OlapOperatorCallInstr;
import crazydev.iccube.olap.eval.operator.unary.OlapUnaryOperator;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapUnaryOperatorCallInstr
extends OlapOperatorCallInstr {
    private final OlapUnaryOperator operator;
    private OlapInstr operand;

    public OlapUnaryOperatorCallInstr(OlapInstrLocationRange range, OlapUnaryOperator operator, OlapInstr operand) {
        super(range);
        this.operator = operator;
        this.setupOperand(operand);
    }

    @Override
    public String typeForError() {
        return "UNARY OPERATOR CALL";
    }

    private void setupOperand(OlapInstr instr) {
        this.operand = instr;
        this.operand.setParent(this);
    }

    @Override
    public OlapOperator getOperator() {
        return this.operator;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.operand.accept(v);
        }
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapLiteralPreparedInstr pLiteral;
        OlapPreparedInstr pOperand = this.operand.prepare(context);
        if (pOperand instanceof OlapLiteralPreparedInstr && (pLiteral = (OlapLiteralPreparedInstr)pOperand).isNumeric()) {
            return pLiteral.asUnaryOperation(this.operator);
        }
        return new OlapUnaryOperatorPreparedInstr(this, this.operator, pOperand);
    }
}

