/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.operator.scalar;

import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarCompareOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarDivideOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarEqualsOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarMinusOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarMultiplyOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarPowerOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarSumOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarUnaryMinusOperator;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class OlapScalarOperators {
    private static final int MAX_SCALAR = 4;
    private static int scalarEntityMapIndex = 0;
    private static OlapScalarCompareOperator.Compare[] compare;
    public static Comparator<OlapScalarEntity> COMPARATOR_FOR_UNIQUE;
    private static OlapScalarEqualsOperator.Equals[] equals;
    private static OlapScalarSumOperator.Sum[] sum;
    private static OlapScalarMinusOperator.Minus[] minus;
    private static OlapScalarMultiplyOperator.Multiply[] multiply;
    private static OlapScalarDivideOperator.Divide[] divide;
    private static OlapScalarPowerOperator.Power[] power;
    private static OlapScalarUnaryMinusOperator.UnaryMinus[] unaryMinus;
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        compare = new OlapScalarCompareOperator.Compare[256];
        Arrays.fill(compare, OlapScalarCompareOperator.INVALID);
        OlapScalarCompareOperator.register();
        equals = new OlapScalarEqualsOperator.Equals[256];
        Arrays.fill(equals, OlapScalarEqualsOperator.INVALID);
        OlapScalarEqualsOperator.register();
        sum = new OlapScalarSumOperator.Sum[256];
        Arrays.fill(sum, OlapScalarSumOperator.INVALID);
        OlapScalarSumOperator.register();
        minus = new OlapScalarMinusOperator.Minus[256];
        Arrays.fill(minus, OlapScalarMinusOperator.INVALID);
        OlapScalarMinusOperator.register();
        multiply = new OlapScalarMultiplyOperator.Multiply[256];
        Arrays.fill(multiply, OlapScalarMultiplyOperator.INVALID);
        OlapScalarMultiplyOperator.register();
        divide = new OlapScalarDivideOperator.Divide[256];
        Arrays.fill(divide, OlapScalarDivideOperator.INVALID);
        OlapScalarDivideOperator.register();
        power = new OlapScalarPowerOperator.Power[256];
        Arrays.fill(power, OlapScalarPowerOperator.INVALID);
        OlapScalarPowerOperator.register();
        unaryMinus = new OlapScalarUnaryMinusOperator.UnaryMinus[16];
        Arrays.fill(unaryMinus, OlapScalarUnaryMinusOperator.INVALID);
        OlapScalarUnaryMinusOperator.register();
        registered = true;
    }

    public static boolean isTrue(OlapScalarEntity ent1) {
        OlapBooleanEntity ent2 = OlapBooleanEntity.TRUE;
        return OlapScalarOperators.equals(ent1, ent2);
    }

    public static boolean equals(OlapScalarEntity ent1, OlapScalarEntity ent2) {
        int pos = OlapScalarOperators.calculateIndex(ent1.getOperatorIndex(), ent2.getOperatorIndex());
        OlapScalarEqualsOperator.Equals eq = equals[pos];
        return eq != null && eq.equals(ent1.asEntityForOperator(), ent2.asEntityForOperator());
    }

    public static int compare(@Nullable Comparator<String> stringComparator, OlapScalarEntity ent1, OlapScalarEntity ent2) {
        OlapScalarEntity ent11 = ent1.asEntityForOperator();
        OlapScalarEntity ent21 = ent2.asEntityForOperator();
        if (stringComparator != null && ent11.isStringForOperator() && ent21.isStringForOperator()) {
            return stringComparator.compare(ent11.asString(), ent21.asString());
        }
        int pos = OlapScalarOperators.calculateIndex(ent1.getOperatorIndex(), ent2.getOperatorIndex());
        return compare[pos].compare(ent11, ent21);
    }

    public static OlapScalarEntity sum(OlapScalarEntity ent1, OlapScalarEntity ent2) {
        int pos = OlapScalarOperators.calculateIndex(ent1.getOperatorIndex(), ent2.getOperatorIndex());
        return sum[pos].sum(ent1.asEntityForOperator(), ent2.asEntityForOperator());
    }

    public static OlapScalarEntity minus(OlapScalarEntity ent1, OlapScalarEntity ent2) {
        int pos = OlapScalarOperators.calculateIndex(ent1.getOperatorIndex(), ent2.getOperatorIndex());
        return minus[pos].minus(ent1.asEntityForOperator(), ent2.asEntityForOperator());
    }

    public static OlapScalarEntity multiply(OlapScalarEntity ent1, OlapScalarEntity ent2) {
        int pos = OlapScalarOperators.calculateIndex(ent1.getOperatorIndex(), ent2.getOperatorIndex());
        return multiply[pos].multiply(ent1.asEntityForOperator(), ent2.asEntityForOperator());
    }

    public static OlapScalarEntity divide(OlapScalarEntity ent1, OlapScalarEntity ent2) {
        int pos = OlapScalarOperators.calculateIndex(ent1.getOperatorIndex(), ent2.getOperatorIndex());
        return divide[pos].divide(ent1.asEntityForOperator(), ent2.asEntityForOperator());
    }

    public static OlapScalarEntity power(OlapScalarEntity ent1, OlapScalarEntity ent2) {
        int pos = OlapScalarOperators.calculateIndex(ent1.getOperatorIndex(), ent2.getOperatorIndex());
        return power[pos].power(ent1.asEntityForOperator(), ent2.asEntityForOperator());
    }

    public static OlapScalarEntity unaryMinus(OlapScalarEntity ent1) {
        int pos = ent1.getOperatorIndex();
        return unaryMinus[pos].unaryMinus(ent1.asEntityForOperator());
    }

    public static int createIndex(Class clazz) {
        OlapScalarOperators.getExistingIndex(clazz);
        int value = scalarEntityMapIndex++;
        if (value >= 16) {
            throw new RuntimeException("MAX_SCALAR is not big enough to hold all scalar entities, please increase size");
        }
        return value;
    }

    public static <T extends OlapScalarEntity, P extends OlapScalarEntity> void register(Class<T> class1, Class<P> class2, OlapScalarCompareOperator.Compare<T, P> operator) {
        OlapScalarOperators.compare[OlapScalarOperators.calculateIndex((int)OlapScalarOperators.getExistingIndex(class1), (int)OlapScalarOperators.getExistingIndex(class2))] = operator;
    }

    public static <T extends OlapScalarEntity, P extends OlapScalarEntity> void register(Class<T> class1, Class<P> class2, OlapScalarEqualsOperator.Equals<T, P> operator) {
        OlapScalarOperators.equals[OlapScalarOperators.calculateIndex((int)OlapScalarOperators.getExistingIndex(class1), (int)OlapScalarOperators.getExistingIndex(class2))] = operator;
    }

    public static <T extends OlapScalarEntity, P extends OlapScalarEntity> void register(Class<T> class1, Class<P> class2, OlapScalarSumOperator.Sum<T, P> operator) {
        OlapScalarOperators.sum[OlapScalarOperators.calculateIndex((int)OlapScalarOperators.getExistingIndex(class1), (int)OlapScalarOperators.getExistingIndex(class2))] = operator;
    }

    public static <T extends OlapScalarEntity, P extends OlapScalarEntity> void register(Class<T> class1, Class<P> class2, OlapScalarMinusOperator.Minus<T, P> operator) {
        OlapScalarOperators.minus[OlapScalarOperators.calculateIndex((int)OlapScalarOperators.getExistingIndex(class1), (int)OlapScalarOperators.getExistingIndex(class2))] = operator;
    }

    public static <T extends OlapScalarEntity, P extends OlapScalarEntity> void register(Class<T> class1, Class<P> class2, OlapScalarMultiplyOperator.Multiply operator) {
        OlapScalarOperators.multiply[OlapScalarOperators.calculateIndex((int)OlapScalarOperators.getExistingIndex(class1), (int)OlapScalarOperators.getExistingIndex(class2))] = operator;
    }

    public static <T extends OlapScalarEntity, P extends OlapScalarEntity> void register(Class<T> class1, Class<P> class2, OlapScalarDivideOperator.Divide operator) {
        OlapScalarOperators.divide[OlapScalarOperators.calculateIndex((int)OlapScalarOperators.getExistingIndex(class1), (int)OlapScalarOperators.getExistingIndex(class2))] = operator;
    }

    public static <T extends OlapScalarEntity, P extends OlapScalarEntity> void register(Class<T> class1, Class<P> class2, OlapScalarPowerOperator.Power operator) {
        OlapScalarOperators.power[OlapScalarOperators.calculateIndex((int)OlapScalarOperators.getExistingIndex(class1), (int)OlapScalarOperators.getExistingIndex(class2))] = operator;
    }

    public static <T extends OlapScalarEntity> void register(Class<T> class1, OlapScalarUnaryMinusOperator.UnaryMinus<T> operator) {
        OlapScalarOperators.unaryMinus[OlapScalarOperators.getExistingIndex(class1)] = operator;
    }

    private static int getExistingIndex(Class clazz) {
        try {
            int value = clazz.getField("operatorIndex").getInt(null);
            return value;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static int calculateIndex(int index1, int index2) {
        return index1 + (index2 << 4);
    }

    static {
        COMPARATOR_FOR_UNIQUE = (o1, o2) -> OlapScalarOperators.compare(null, o1, o2);
    }
}

