/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.operator.binary;

import crazydev.iccube.olap.eval.execinstr.OlapBinaryOperatorPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.operator.binary.OlapBinaryOperator;
import crazydev.iccube.olap.eval.operator.common.OlapOperator;
import crazydev.iccube.olap.eval.operator.common.OlapOperatorCallInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapBinaryOperatorCallInstr
extends OlapOperatorCallInstr {
    protected final OlapBinaryOperator operator;
    protected final OlapInstr left;
    protected final OlapInstr right;

    public OlapBinaryOperatorCallInstr(OlapInstrLocationRange range, OlapBinaryOperator operator, OlapInstr left, OlapInstr right) {
        super(range);
        this.operator = operator;
        this.left = left;
        this.left.setParent(this);
        this.right = right;
        this.right.setParent(this);
    }

    @Override
    public String typeForError() {
        return "BINARY OPERATOR CALL";
    }

    @Override
    public OlapOperator getOperator() {
        return this.operator;
    }

    public OlapInstr getLeft() {
        return this.left;
    }

    public OlapInstr getRight() {
        return this.right;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.left.accept(v);
            this.right.accept(v);
        }
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapPreparedInstr pLeft = this.left.prepare(context);
        OlapPreparedInstr pRight = this.right.prepare(context);
        return new OlapBinaryOperatorPreparedInstr(this, this.operator, pLeft, pRight);
    }
}

