/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.method;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapWrappedEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.method.OlapJavaMethod;
import crazydev.iccube.olap.eval.method.OlapJavaMethodHelper;
import crazydev.iccube.olap.eval.method.OlapMethodCallInstr;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class OlapJavaObjectMethodHelper
extends OlapJavaMethodHelper {
    private GFNode currentObject;

    public OlapJavaObjectMethodHelper(OlapMethodCallInstr instr, boolean isField) {
        super(instr, isField);
    }

    @Override
    public void setCurrentObject(GFNode currentObject) {
        this.currentObject = currentObject;
    }

    @Override
    protected String getCallNotation() {
        return "->";
    }

    @Nullable
    private Object executeCurrentObject(GFContext context, GFTupleEvaluator cache) {
        OlapEntity entity = this.currentObject.execute(context, cache);
        if (entity.isToValueApplicable(context, cache)) {
            OlapScalarEntity scalarEntity = entity.toValue(context, cache);
            if (scalarEntity instanceof OlapWrappedEntity) {
                Object underlying = scalarEntity.asValue();
                return underlying;
            }
            entity = scalarEntity;
        }
        if (entity.isMdxNull()) {
            return null;
        }
        return entity;
    }

    @Override
    protected Object doExecuteForField(GFContext context, GFTupleEvaluator cache) throws NoSuchFieldException, IllegalAccessException {
        Object thisObject = this.executeCurrentObject(context, cache);
        if (thisObject == null) {
            return OlapNullEntity.INSTANCE;
        }
        Class<?> clazz = thisObject.getClass();
        String methodName = this.getMethodName();
        Field field = this.lookupJavaField(clazz, methodName);
        Object result = field.get(thisObject);
        return result;
    }

    @Override
    protected Object doExecuteForNoArgMethod(GFContext context, GFTupleEvaluator cache) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Object thisObject = this.executeCurrentObject(context, cache);
        if (thisObject == null) {
            return OlapNullEntity.INSTANCE;
        }
        Class<?> clazz = thisObject.getClass();
        String methodName = this.getMethodName();
        OlapJavaMethod method = this.lookupJavaMethod(clazz, methodName);
        Object result = method.invoke(thisObject, new Object[0]);
        return result;
    }

    @Override
    protected Object doExecuteForMethod(GFContext context, GFTupleEvaluator cache) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Object thisObject = this.executeCurrentObject(context, cache);
        if (thisObject == null) {
            return OlapNullEntity.INSTANCE;
        }
        Class<?> clazz = thisObject.getClass();
        String methodName = this.getMethodName();
        OlapEntity[] scalarEntityParams = OlapMethodCallInstr.executeArgs(context, cache, this.gfArgs);
        OlapJavaMethod method = this.lookupJavaMethod(clazz, methodName, (OlapScalarEntity[])scalarEntityParams);
        Object[] jParams = OlapJavaObjectMethodHelper.convertScalarEntityParamsToJavaNativeValues(this.location, method, scalarEntityParams);
        Object result = method.invoke(thisObject, jParams);
        return result;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer, boolean recursive) {
        super.forEachNode(consumer, recursive);
        if (this.currentObject != null) {
            if (recursive) {
                this.currentObject.forEachNode(consumer);
            } else {
                consumer.accept(this.currentObject);
            }
        }
    }
}

