/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.method;

import crazydev.iccube.olap.eval.execinstr.OlapGenericMethodPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.method.OlapJavaObjectMethodHelper;
import crazydev.iccube.olap.eval.method.OlapMethodCallArgInstr;
import crazydev.iccube.olap.eval.method.OlapMethodCallInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapJavaObjectMethodCallInstr
extends OlapMethodCallInstr {
    private final OlapInstr currentObject;
    private final boolean isField;
    private final OlapMethodCallArgInstr[] instArgs;

    public OlapJavaObjectMethodCallInstr(OlapInstrLocationRange range, OlapInstr currentObject, String methodName, boolean isField, OlapMethodCallArgInstr[] instArgs) {
        super(range, methodName);
        this.currentObject = currentObject;
        this.isField = isField;
        this.instArgs = instArgs;
        currentObject.setParent(this);
        for (int idx = 0; idx < instArgs.length; ++idx) {
            instArgs[idx].setParent(this);
        }
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapPreparedInstr[] args = new OlapPreparedInstr[this.instArgs.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.instArgs[i].prepare(context);
        }
        OlapJavaObjectMethodHelper helper = new OlapJavaObjectMethodHelper(this, this.isField);
        return new OlapGenericMethodPreparedInstr(this, helper, this.currentObject.prepare(context), args);
    }

    @Override
    public String getModuleName() {
        return "object";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.currentObject.accept(v);
            for (int i = 0; i < this.instArgs.length; ++i) {
                this.instArgs[i].accept(v);
            }
        }
    }

    @Override
    public String typeForError() {
        return "OBJECT FUNCTION CALL";
    }
}

