/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.method;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.eval.method.OlapJavaMethod;
import crazydev.iccube.olap.eval.method.OlapJavaRegularMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OlapJavaMethodReflectionUtils {
    private static final Map<FieldKey, Field> fields = new ConcurrentHashMap<FieldKey, Field>();
    private static final Map<MethodKey, OlapJavaRegularMethod> methods = new ConcurrentHashMap<MethodKey, OlapJavaRegularMethod>();
    private static final Map<MethodKeyX, OlapJavaRegularMethod> methodsX = new ConcurrentHashMap<MethodKeyX, OlapJavaRegularMethod>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field lookupField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        FieldKey key = new FieldKey(clazz, fieldName);
        Field field = fields.get(key);
        if (field != null) {
            return field;
        }
        Map<FieldKey, Field> map = fields;
        synchronized (map) {
            field = fields.get(key);
            if (field == null) {
                field = key.clazz.getField(key.fieldName);
                field.setAccessible(true);
                fields.put(key, field);
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OlapJavaMethod lookupMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        MethodKey key = new MethodKey(clazz, methodName);
        OlapJavaRegularMethod javaMethod = methods.get(key);
        if (javaMethod != null) {
            return javaMethod;
        }
        Map<MethodKey, OlapJavaRegularMethod> map = methods;
        synchronized (map) {
            javaMethod = methods.get(key);
            if (javaMethod == null) {
                Method method = clazz.getMethod(methodName, new Class[0]);
                javaMethod = new OlapJavaRegularMethod(method);
                methods.put(key, javaMethod);
            }
        }
        return javaMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends OlapEntity> OlapJavaMethod lookupMethod(Class<?> clazz, String methodName, T[] methodParams) throws NoSuchMethodException {
        MethodKeyX key = new MethodKeyX(clazz, methodName, (OlapEntity[])methodParams);
        OlapJavaRegularMethod javaMethod = methodsX.get(key);
        if (javaMethod != null) {
            return javaMethod;
        }
        Map<MethodKeyX, OlapJavaRegularMethod> map = methodsX;
        synchronized (map) {
            javaMethod = methodsX.get(key);
            if (javaMethod == null) {
                javaMethod = OlapJavaMethodReflectionUtils.lookupMethodX(clazz, (String)methodName, methodParams);
                methodsX.put(key, javaMethod);
            }
        }
        return javaMethod;
    }

    private static <T extends OlapEntity> OlapJavaRegularMethod lookupMethodX(Class<?> clazz, String methodName, T[] methodParams) throws NoSuchMethodException {
        try {
            Class[] underlyingJavaTypes = new Class[methodParams.length];
            for (int idx = 0; idx < methodParams.length; ++idx) {
                T methodParamType = methodParams[idx];
                underlyingJavaTypes[idx] = methodParamType == null ? null : methodParamType.getClass();
            }
            Method method = clazz.getMethod(methodName, underlyingJavaTypes);
            return new OlapJavaRegularMethod(method);
        }
        catch (NoSuchMethodException ex2) {
            try {
                Class[] underlyingJavaTypes = new Class[methodParams.length];
                for (int idx = 0; idx < methodParams.length; ++idx) {
                    T methodParamType = methodParams[idx];
                    underlyingJavaTypes[idx] = methodParamType == null ? null : methodParamType.getUnderlyingJavaNativeValueType();
                }
                Method method = clazz.getMethod(methodName, underlyingJavaTypes);
                return new OlapJavaRegularMethod(method);
            }
            catch (NoSuchMethodException ex) {
                Method[] availableMethods = clazz.getMethods();
                for (int idx = 0; idx < availableMethods.length; ++idx) {
                    Class[] availableMethodParamTypes;
                    Method availableMethod = availableMethods[idx];
                    if (!availableMethod.getName().equals(methodName) || !OlapJavaMethodReflectionUtils.areTypesCompatibles(availableMethodParamTypes = availableMethod.getParameterTypes(), methodParams)) continue;
                    return new OlapJavaRegularMethod(availableMethod);
                }
                throw ex;
            }
        }
    }

    private static boolean areTypesCompatibles(Class[] targets, OlapEntity[] sources) {
        if (targets.length != sources.length) {
            return false;
        }
        for (int idx = 0; idx < targets.length; ++idx) {
            OlapEntity source = sources[idx];
            Class target = targets[idx];
            if (source == null || source.isConvertibleToJavaNativeValueType(target)) continue;
            return false;
        }
        return true;
    }

    static class FieldKey {
        final Class<?> clazz;
        final String fieldName;

        FieldKey(Class<?> clazz, String fieldName) {
            this.clazz = clazz;
            this.fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            if (!this.clazz.equals(fieldKey.clazz)) {
                return false;
            }
            return this.fieldName.equals(fieldKey.fieldName);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            return result;
        }
    }

    static class MethodKey {
        final Class<?> clazz;
        final String methodName;

        MethodKey(Class<?> clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            if (!this.clazz.equals(methodKey.clazz)) {
                return false;
            }
            return this.methodName.equals(methodKey.methodName);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.methodName.hashCode();
            return result;
        }
    }

    static class MethodKeyX {
        final Class<?> clazz;
        final String methodName;
        final Class<?>[] paramTypes;
        final Class<?>[] paramUnderlyingTypes;

        MethodKeyX(Class<?> clazz, String methodName, OlapEntity[] methodParams) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.paramTypes = new Class[methodParams.length];
            this.paramUnderlyingTypes = new Class[methodParams.length];
            for (int ii = 0; ii < methodParams.length; ++ii) {
                OlapEntity methodParam = methodParams[ii];
                this.paramTypes[ii] = methodParam != null ? methodParam.getClass() : null;
                this.paramUnderlyingTypes[ii] = methodParam != null ? methodParam.getUnderlyingJavaNativeValueType() : null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKeyX that = (MethodKeyX)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            if (!Arrays.equals(this.paramTypes, that.paramTypes)) {
                return false;
            }
            return Arrays.equals(this.paramUnderlyingTypes, that.paramUnderlyingTypes);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.paramTypes);
            result = 31 * result + Arrays.hashCode(this.paramUnderlyingTypes);
            return result;
        }
    }
}

