/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.lambda.callback;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.lambda.callback.OlapMultipleLambdaCallback;
import java.io.Serializable;

public abstract class OlapDefaultMultipleLambdaCallback
implements OlapMultipleLambdaCallback {
    private final String lambdaArgName1;
    private final String lambdaArgName2;

    protected OlapDefaultMultipleLambdaCallback(String lambdaArgName1, String lambdaArgName2) {
        this.lambdaArgName1 = lambdaArgName1;
        this.lambdaArgName2 = lambdaArgName2;
    }

    @Override
    public boolean onLambdaEvaluatedAsNonScalar(OlapInstrExecutionContext context, OlapTuple tuple, OlapEntity ... values) {
        return this.onUnexpectedValueType(context, tuple, values);
    }

    protected boolean onUnexpectedValueType(OlapInstrExecutionContext context, OlapTuple tuple, OlapEntity ... values) {
        Object actualType;
        String argName = this.lambdaArgName1 + " and " + this.lambdaArgName2;
        String expectedType = "scalar and scalar";
        if (values == null) {
            actualType = "missing and missing";
        } else if (values.length == 2) {
            actualType = values[0].getFriendlyTypeName() + " and " + values[1].getFriendlyTypeName();
        } else {
            StringBuilder sb = new StringBuilder();
            for (int idx = 0; idx < values.length; ++idx) {
                OlapEntity value = values[idx];
                if (idx > 0) {
                    sb.append(" and ");
                }
                sb.append(value.getFriendlyTypeName());
            }
            actualType = sb.toString();
        }
        throw new OlapEvaluationException(context, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{argName, "scalar and scalar", actualType, ""});
    }
}

