/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.id;

import crazydev.common.collection.CdPair;
import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapNeutralTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapEntityPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapTuplePreparedInstr;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.request.OlapServerCancelledRequestException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class OlapIdentifierInstr
extends OlapExecutedWithPreparedInstr<OlapEvaluationContext> {
    private final ReentrantLock LOCK = new ReentrantLock();
    private final OlapEntityIdentifier id;
    @Nullable
    private final String asSingleRegularName;
    private final Map<String, CdPair<OlapEntity, RuntimeException>> cached = new ConcurrentHashMap<String, CdPair<OlapEntity, RuntimeException>>();

    public OlapIdentifierInstr(OlapInstrLocationRange range, OlapEntityIdentifier id) {
        super(range);
        this.id = id;
        this.asSingleRegularName = id.asSingleRegularName();
    }

    public OlapIdentifierInstr removeLastPart() {
        return new OlapIdentifierInstr(this.getLocationRange(), this.id.subIdentifier(0, this.id.getPartCount() - 1));
    }

    @Override
    public String typeForError() {
        return "IDENTIFIER";
    }

    public OlapEntityIdentifier getId() {
        return this.id;
    }

    @Override
    public boolean isConstrainedEnabled() {
        return false;
    }

    @Override
    public String toStringForDebugger() {
        return this.id.toString();
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    @Nullable
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapEntity entity = this.resolveOlapEntity(context);
        if (entity instanceof OlapTuple) {
            OlapTuple tuple = (OlapTuple)entity;
            return new OlapTuplePreparedInstr(this, tuple);
        }
        return new OlapEntityPreparedInstr(this, entity);
    }

    private OlapEntity resolveOlapEntity(IOlapPrepareContext context) {
        if (this.asSingleRegularName != null) {
            if ("\u2205".equals(this.asSingleRegularName)) {
                return OlapNeutralTupleSet.INSTANCE;
            }
            OlapEntity ppEntity = context.lookupCurrent(this.asSingleRegularName);
            if (ppEntity != null) {
                return ppEntity;
            }
            OlapNonScalarEntity entity = context.lookupAsNamedSet(this.asSingleRegularName);
            if (!entity.isMdxNull()) {
                return entity;
            }
        }
        if (context.getMemberFilter() != null) {
            return this.doResolveOlapCacheableEntity(context);
        }
        OlapNameContext nameContext = context.getNameContext();
        String cubeName = context.getUnderlyingCubeName(nameContext);
        CdPair<OlapEntity, RuntimeException> pair = this.computeIfAbsent(cubeName, s -> {
            try {
                OlapEntity entity = this.doResolveOlapCacheableEntity(context);
                return new CdPair((Object)entity, null);
            }
            catch (RuntimeException error) {
                return new CdPair(null, (Object)error);
            }
        });
        RuntimeException error = (RuntimeException)pair.getSnd();
        if (error != null) {
            throw error;
        }
        OlapEntity entity = (OlapEntity)pair.getFst();
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CdPair<OlapEntity, RuntimeException> computeIfAbsent(String key, Function<String, CdPair<OlapEntity, RuntimeException>> mappingFunction) {
        CdPair<OlapEntity, RuntimeException> pair = this.cached.get(key);
        if (pair != null) {
            return pair;
        }
        try {
            this.LOCK.lockInterruptibly();
            try {
                pair = this.cached.get(key);
                if (pair != null) {
                    CdPair<OlapEntity, RuntimeException> cdPair = pair;
                    return cdPair;
                }
                pair = mappingFunction.apply(key);
                if (pair.snd != null) {
                    OlapLoggers.MDX_EVALUATION.info((Object)"[id-instr] cache ignored for [%s] on error : %s".formatted(key, pair.snd), (Throwable)pair.snd);
                    CdPair<OlapEntity, RuntimeException> cdPair = pair;
                    return cdPair;
                }
                this.cached.put(key, pair);
                CdPair<OlapEntity, RuntimeException> cdPair = pair;
                return cdPair;
            }
            finally {
                this.LOCK.unlock();
            }
        }
        catch (InterruptedException ex) {
            throw new OlapServerCancelledRequestException("interrupted while resolving " + this.id.asString());
        }
    }

    private OlapEntity doResolveOlapCacheableEntity(IOlapPrepareContext context) {
        OlapEntityIdentifier memberId;
        String propertyName;
        OlapEntity ppEntity;
        String part0;
        String part1;
        if (this.id.getPartCount() == 2 && "all".equalsIgnoreCase(part1 = this.id.getPart(1).asName()) && (part0 = this.id.getPart(0).asName()) != null && part0.toLowerCase().startsWith("$current") && (ppEntity = context.lookupCurrent(part0)) instanceof OlapHierarchy) {
            OlapHierarchy ppEntityH = (OlapHierarchy)ppEntity;
            OlapMember all = ppEntityH.getAllMember();
            if (all != null) {
                return all;
            }
            return OlapNullEntity.INSTANCE;
        }
        OlapNameContext nameContext = context.getNameContext();
        OlapNonScalarEntity entity = context.lookupEntityByMdxIdentifier(nameContext, OlapMdxEntityLookupKinds.ALL, this.id);
        context.assertEntityUsage(this.id, entity);
        if (entity.isFilteredOut()) {
            return OlapNullEntity.INSTANCE;
        }
        if (!entity.isMdxNull()) {
            return entity;
        }
        if (this.id.getPartCount() == 1 && this.id.getLastPartAsName().startsWith("XL_Filter_HelperSet_") && context.getRequestProperties().isExcelFixFilterHelperSet()) {
            return (OlapEntity)this.onInstrExecutionError(context, CdMdxErrorCode.PARSE_EXCEL_FILTER_HELPER_SET, new Serializable[]{this.id.asString()});
        }
        OlapIntrinsicMemberProperty property = null;
        OlapNonScalarEntity memberEntity = null;
        if (!this.id.isKey() && this.id.getPartCount() > 1 && (property = context.getIntrinsicProperty(propertyName = this.id.getLastPartAsName())) != null && (memberEntity = context.lookupEntityByMdxIdentifier(nameContext, OlapMdxEntityLookupKinds.ALL, memberId = this.id.subIdentifier(0, this.id.getPartCount() - 1))) instanceof OlapMember) {
            OlapScalarEntity value = property.eval(context.getMemberPropertyEvalContext(), (OlapMember)memberEntity);
            return value;
        }
        boolean isDimensionOrHierarchyPrefix = context.isDimensionOrHierarchyPrefix(this.id);
        if (!isDimensionOrHierarchyPrefix) {
            return (OlapEntity)OlapIdentifierInstr.onInstrExecutionError(context, OlapErrorCode.UNKNOWN_DIMENSION_HIERARCHY, new Serializable[]{this.id.asString()});
        }
        if (OlapCaseInsensitiveName.equals(this.id.getFirstPartAsName(), "Measures")) {
            return (OlapEntity)OlapIdentifierInstr.onInstrExecutionError(context, OlapErrorCode.UNKNOWN_MEASURE, new Serializable[]{this.id.asString()});
        }
        if (context.getRequestProperties().isMdxEvalUnknownMemberError()) {
            return (OlapEntity)OlapIdentifierInstr.onInstrExecutionError(context, OlapErrorCode.UNKNOWN_ENTITY, new Serializable[]{this.id.asString()});
        }
        if (property != null) {
            throw new OlapEvaluationException(context, OlapErrorCode.PROPERTY_TYPE_MISMATCH, new Serializable[]{property.getName(), "member", memberEntity != null ? memberEntity.getFriendlyTypeName() : "<null>"});
        }
        return OlapNullEntity.INSTANCE;
    }

    public String toString() {
        return this.id.toString();
    }
}

