/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.tuple;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.literal.OlapLongLiteralInstr;

public class OlapItemFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Item";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, Integer.MAX_VALUE){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapItemFunction() {
        super(NAME, ARGS);
    }

    @Override
    public int getLambdaLimit(OlapInstr[] args) {
        OlapInstr index;
        if (args.length >= 2 && (index = args[1]) instanceof OlapLongLiteralInstr) {
            OlapLongLiteralInstr indexI = (OlapLongLiteralInstr)index;
            int indexV = indexI.getValue().intValue();
            return indexV + 1;
        }
        return -1;
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int index = args.toInteger(context, 1);
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "tuple|set");
        if (arg0.isMdxNull()) {
            return OlapItemFunction.asNull();
        }
        OlapTuple tuple = args.toTupleOptionalIfApplicable(context, 0);
        if (tuple != null) {
            if (tuple.isFilteredOut()) {
                return OlapItemFunction.asNull();
            }
            if (0 <= index && index < tuple.getMemberCount()) {
                return tuple.getMember(index);
            }
            return OlapItemFunction.asNull();
        }
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 0);
        return OlapItemFunction.asNullable(set._getSlow(index));
    }
}

