/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapVisualTotalsCluster {
    private final boolean addIntermediateNodes;
    private final String pattern;
    private final Map<OlapMember, Node> visualTotalMap = new HashMap<OlapMember, Node>();
    @Nullable
    private OlapHierarchy hierarchy;

    public OlapVisualTotalsCluster(OlapTupleSet<OlapMember> members, String pattern, boolean addIntermediateNodes) {
        this.pattern = pattern;
        this.addIntermediateNodes = addIntermediateNodes;
        this.buildClusterStructure(members.getIterator(false));
    }

    public OlapVisualTotalsCluster(OlapProperties properties, OlapTupleSet<OlapMember> members, String pattern) {
        this(members, pattern, properties.isVisualTotalsIntermediateMembers());
    }

    public OlapVisualTotalsCluster(OlapProperties properties, final OlapIterator<? extends OlapTuple> tuples, final int pos, String pattern) {
        this.pattern = pattern;
        this.addIntermediateNodes = properties.isVisualTotalsIntermediateMembers();
        this.buildClusterStructure((OlapIterator<OlapMember>)new OlapBaseIterator<OlapMember>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            @Nullable
            public OlapTupleDimensionality getTupleDimensionality() {
                return tuples.getTupleDimensionality();
            }

            @Override
            public long fastEstimatedSize() {
                return tuples.fastEstimatedSize();
            }

            @Override
            public boolean mightHaveCalcMember() {
                return tuples.mightHaveCalcMember();
            }

            @Override
            public boolean isMemberIterator() {
                return true;
            }

            @Override
            public boolean isMembersCrossjoin() {
                return true;
            }

            @Override
            public void reset() {
                tuples.reset();
            }

            @Override
            protected OlapMember safeNext() {
                OlapTuple tuple = (OlapTuple)tuples.next();
                return tuple == null ? null : tuple.getMember(pos);
            }

            @Override
            public OlapIterator<OlapMember> newInstance() {
                throw new CdDoNotCallMeProgrammingException();
            }
        });
    }

    public boolean isEmpty() {
        return this.visualTotalMap.size() == 0;
    }

    public Node getClusterNode(OlapMember member) {
        return this.visualTotalMap.get(member);
    }

    private void buildClusterStructure(OlapIterator<OlapMember> iterator) {
        OlapMember member;
        Node node = null;
        iterator.reset();
        while ((member = iterator.next()) != null) {
            if (node == null) {
                this.hierarchy = member.getHierarchy();
                node = new Node(this, member);
                continue;
            }
            if (OlapVisualTotalsCluster.isVisualTotalChild(node.root, member)) {
                node.add(member);
                continue;
            }
            this.addNodeToVisualMap(node);
            node = new Node(this, member);
        }
        this.addNodeToVisualMap(node);
    }

    private void addNodeToVisualMap(Node node) {
        if (node != null && node.hasChildren()) {
            this.visualTotalMap.put(node.root, node);
            for (Node child : node.children) {
                this.addNodeToVisualMap(child);
            }
        }
    }

    private static boolean isVisualTotalChild(OlapMember clusterRoot, OlapMember member) {
        return member.isDescendant(clusterRoot);
    }

    public String getCaption(OlapMember member, String currentCaption) {
        if (this.visualTotalMap.containsKey(member)) {
            return this.pattern.replace("*", currentCaption);
        }
        return currentCaption;
    }

    public boolean hasCaption(OlapMember member) {
        return this.visualTotalMap.containsKey(member);
    }

    @Nullable
    public OlapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public class Node {
        private final OlapMember root;
        private final List<Node> children;
        private OlapLevel visualChildrenLevel;
        final /* synthetic */ OlapVisualTotalsCluster this$0;

        public Node(OlapVisualTotalsCluster this$0, OlapMember root) {
            OlapVisualTotalsCluster olapVisualTotalsCluster = this$0;
            Objects.requireNonNull(olapVisualTotalsCluster);
            this.this$0 = olapVisualTotalsCluster;
            this.children = new ArrayList<Node>();
            this.root = root;
        }

        public boolean add(OlapMember member) {
            if (!OlapVisualTotalsCluster.isVisualTotalChild(this.root, member)) {
                return false;
            }
            if (this.children.size() == 0) {
                this.addToChildren(member);
                return true;
            }
            if (member.getLevel() == this.visualChildrenLevel) {
                if (this.getNodeInChildren(member) != null) {
                    return true;
                }
                this.addToChildren(member);
                return true;
            }
            if (this.visualChildrenLevel.getDepth() > member.getLevel().getDepth()) {
                this.children.clear();
                this.addToChildren(member);
                return true;
            }
            Node lastNode = this.children.get(this.children.size() - 1);
            return lastNode.add(member);
        }

        @Nullable
        private Node getNodeInChildren(OlapMember member) {
            for (Node child : this.children) {
                if (!OlapMember.equal(child.root, member)) continue;
                return child;
            }
            return null;
        }

        private void addToChildren(OlapMember member) {
            this.visualChildrenLevel = member.getLevel();
            if (this.this$0.addIntermediateNodes) {
                OlapMember[] branch = OlapMember.getBranch(this.root, member);
                this.addBranch(branch, 0);
            } else {
                this.children.add(new Node(this.this$0, member));
            }
        }

        private void addBranch(OlapMember[] branch, int start) {
            Node root = this;
            for (int i = start; i < branch.length; ++i) {
                OlapMember member = branch[i];
                Node node = root.getNodeInChildren(member);
                if (node != null) {
                    node.addBranch(branch, start + 1);
                    break;
                }
                Node newNode = new Node(this.this$0, member);
                root.children.add(newNode);
                root = newNode;
            }
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public List<Node> children() {
            return this.children;
        }

        public List<OlapMember> getAllVisualMembers() {
            ArrayList<OlapMember> visualMembers = new ArrayList<OlapMember>();
            this.addVisualMembers(visualMembers);
            return visualMembers;
        }

        private void addVisualMembers(List<OlapMember> visualMembers) {
            if (this.children.isEmpty()) {
                visualMembers.add(this.root);
            } else {
                for (Node child : this.children) {
                    child.addVisualMembers(visualMembers);
                }
            }
        }
    }
}

